/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.rest.voice.v1.dialingpermissions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import lombok.ToString;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Country extends Resource {
    private static final long serialVersionUID = 83622253964242L;

    /**
     * Create a CountryFetcher to execute fetch.
     *
     * @param pathIsoCode The ISO country code
     * @return CountryFetcher capable of executing the fetch
     */
    public static CountryFetcher fetcher(final String pathIsoCode) {
        return new CountryFetcher(pathIsoCode);
    }

    /**
     * Create a CountryReader to execute read.
     *
     * @return CountryReader capable of executing the read
     */
    public static CountryReader reader() {
        return new CountryReader();
    }

    /**
     * Converts a JSON String into a Country object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Country object represented by the provided JSON
     */
    public static Country fromJson(final String json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Country.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Country object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Country object represented by the provided JSON
     */
    public static Country fromJson(final InputStream json, final ObjectMapper objectMapper) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Country.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String isoCode;
    private final String name;
    private final String continent;
    private final List<String> countryCodes;
    private final Boolean lowRiskNumbersEnabled;
    private final Boolean highRiskSpecialNumbersEnabled;
    private final Boolean highRiskTollfraudNumbersEnabled;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private Country(@JsonProperty("iso_code")
                    final String isoCode,
                    @JsonProperty("name")
                    final String name,
                    @JsonProperty("continent")
                    final String continent,
                    @JsonProperty("country_codes")
                    final List<String> countryCodes,
                    @JsonProperty("low_risk_numbers_enabled")
                    final Boolean lowRiskNumbersEnabled,
                    @JsonProperty("high_risk_special_numbers_enabled")
                    final Boolean highRiskSpecialNumbersEnabled,
                    @JsonProperty("high_risk_tollfraud_numbers_enabled")
                    final Boolean highRiskTollfraudNumbersEnabled,
                    @JsonProperty("url")
                    final URI url,
                    @JsonProperty("links")
                    final Map<String, String> links) {
        this.isoCode = isoCode;
        this.name = name;
        this.continent = continent;
        this.countryCodes = countryCodes;
        this.lowRiskNumbersEnabled = lowRiskNumbersEnabled;
        this.highRiskSpecialNumbersEnabled = highRiskSpecialNumbersEnabled;
        this.highRiskTollfraudNumbersEnabled = highRiskTollfraudNumbersEnabled;
        this.url = url;
        this.links = links;
    }

    /**
     * Returns The ISO country code.
     *
     * @return The ISO country code
     */
    public final String getIsoCode() {
        return this.isoCode;
    }

    /**
     * Returns The name of the country.
     *
     * @return The name of the country
     */
    public final String getName() {
        return this.name;
    }

    /**
     * Returns The name of the continent in which the country is located.
     *
     * @return The name of the continent in which the country is located
     */
    public final String getContinent() {
        return this.continent;
    }

    /**
     * Returns The E.164 assigned country codes(s).
     *
     * @return The E.164 assigned country codes(s)
     */
    public final List<String> getCountryCodes() {
        return this.countryCodes;
    }

    /**
     * Returns Whether dialing to low-risk numbers is enabled.
     *
     * @return Whether dialing to low-risk numbers is enabled
     */
    public final Boolean getLowRiskNumbersEnabled() {
        return this.lowRiskNumbersEnabled;
    }

    /**
     * Returns Whether dialing to high-risk special services numbers is enabled.
     *
     * @return Whether dialing to high-risk special services numbers is enabled
     */
    public final Boolean getHighRiskSpecialNumbersEnabled() {
        return this.highRiskSpecialNumbersEnabled;
    }

    /**
     * Returns Whether dialing to high-risk toll fraud numbers is enabled, else
     * `false`.
     *
     * @return Whether dialing to high-risk toll fraud numbers is enabled, else
     *         `false`
     */
    public final Boolean getHighRiskTollfraudNumbersEnabled() {
        return this.highRiskTollfraudNumbersEnabled;
    }

    /**
     * Returns The absolute URL of this resource.
     *
     * @return The absolute URL of this resource
     */
    public final URI getUrl() {
        return this.url;
    }

    /**
     * Returns A list of URLs related to this resource.
     *
     * @return A list of URLs related to this resource
     */
    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Country other = (Country) o;

        return Objects.equals(isoCode, other.isoCode) &&
               Objects.equals(name, other.name) &&
               Objects.equals(continent, other.continent) &&
               Objects.equals(countryCodes, other.countryCodes) &&
               Objects.equals(lowRiskNumbersEnabled, other.lowRiskNumbersEnabled) &&
               Objects.equals(highRiskSpecialNumbersEnabled, other.highRiskSpecialNumbersEnabled) &&
               Objects.equals(highRiskTollfraudNumbersEnabled, other.highRiskTollfraudNumbersEnabled) &&
               Objects.equals(url, other.url) &&
               Objects.equals(links, other.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isoCode,
                            name,
                            continent,
                            countryCodes,
                            lowRiskNumbersEnabled,
                            highRiskSpecialNumbersEnabled,
                            highRiskTollfraudNumbersEnabled,
                            url,
                            links);
    }
}