/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

/**
 * TwiML wrapper for {@code <Autopilot>}
 */
@JsonDeserialize(builder = Autopilot.Builder.class)
public class Autopilot extends TwiML {
    private final String name;

    /**
     * For XML Serialization/Deserialization
     */
    private Autopilot() {
        this(new Builder((String) null));
    }

    /**
     * Create a new {@code <Autopilot>} element
     */
    private Autopilot(Builder b) {
        super("Autopilot", b);
        this.name = b.name;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getName() == null ? null : this.getName();
    }

    /**
     * Autopilot assistant sid or unique name
     *
     * @return Autopilot assistant sid or unique name
     */
    public String getName() {
        return name;
    }

    /**
     * Create a new {@code <Autopilot>} element
     */
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <Autopilot.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a Autopilot.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private String name;

        /**
         * Create a {@code <Autopilot>} with name
         */
        public Builder(String name) {
            this.name = name;
        }

        /**
         * Create a {@code <Autopilot>} (for XML deserialization)
         */
        private Builder() {
        }

        /**
         * Create and return resulting {@code <Autopilot>} element
         */
        public Autopilot build() {
            return new Autopilot(this);
        }
    }
}