/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

import java.util.HashMap;
import java.util.Map;

/**
 * TwiML wrapper for {@code <Room>}
 */
@JsonDeserialize(builder = Room.Builder.class)
public class Room extends TwiML {
    private final String participantIdentity;
    private final String name;

    /**
     * For XML Serialization/Deserialization
     */
    private Room() {
        this(new Builder((String) null));
    }

    /**
     * Create a new {@code <Room>} element
     */
    private Room(Builder b) {
        super("Room", b);
        this.participantIdentity = b.participantIdentity;
        this.name = b.name;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getName() == null ? null : this.getName();
    }

    /**
     * Attributes to set on the generated XML element
     *
     * @return A Map of attribute keys to values
     */
    protected Map<String, String> getElementAttributes() {
        // Preserve order of attributes
        Map<String, String> attrs = new HashMap<>();

        if (this.getParticipantIdentity() != null) {
            attrs.put("participantIdentity", this.getParticipantIdentity());
        }

        return attrs;
    }

    /**
     * Participant identity when connecting to the Room
     *
     * @return Participant identity when connecting to the Room
     */
    public String getParticipantIdentity() {
        return participantIdentity;
    }

    /**
     * Room name
     *
     * @return Room name
     */
    public String getName() {
        return name;
    }

    /**
     * Create a new {@code <Room>} element
     */
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <Room.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a Room.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private String participantIdentity;
        private String name;

        /**
         * Create a {@code <Room>} with name
         */
        public Builder(String name) {
            this.name = name;
        }

        /**
         * Create a {@code <Room>} (for XML deserialization)
         */
        private Builder() {
        }

        /**
         * Participant identity when connecting to the Room
         */
        @JacksonXmlProperty(isAttribute = true, localName = "participantIdentity")
        public Builder participantIdentity(String participantIdentity) {
            this.participantIdentity = participantIdentity;
            return this;
        }

        /**
         * Create and return resulting {@code <Room>} element
         */
        public Room build() {
            return new Room(this);
        }
    }
}