/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;

/**
 * TwiML wrapper for {@code <Sim>}
 */
@JsonDeserialize(builder = Sim.Builder.class)
public class Sim extends TwiML {
    private final String simSid;

    /**
     * For XML Serialization/Deserialization
     */
    private Sim() {
        this(new Builder((String) null));
    }

    /**
     * Create a new {@code <Sim>} element
     */
    private Sim(Builder b) {
        super("Sim", b);
        this.simSid = b.simSid;
    }

    /**
     * The body of the TwiML element
     *
     * @return Element body as a string if present else null
     */
    protected String getElementBody() {
        return this.getSimSid() == null ? null : this.getSimSid();
    }

    /**
     * SIM SID
     *
     * @return SIM SID
     */
    public String getSimSid() {
        return simSid;
    }

    /**
     * Create a new {@code <Sim>} element
     */
    public static class Builder extends TwiML.Builder<Builder> {
        /**
         * Create and return a {@code <Sim.Builder>} from an XML string
         */
        public static Builder fromXml(final String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            } catch (final JsonProcessingException jpe) {
                throw new TwiMLException(
                    "Failed to deserialize a Sim.Builder from the provided XML string: " + jpe.getMessage());
            } catch (final Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        private String simSid;

        /**
         * Create a {@code <Sim>} with simSid
         */
        public Builder(String simSid) {
            this.simSid = simSid;
        }

        /**
         * Create a {@code <Sim>} (for XML deserialization)
         */
        private Builder() {
        }

        /**
         * Create and return resulting {@code <Sim>} element
         */
        public Sim build() {
            return new Sim(this);
        }
    }
}