/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Api
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class OutgoingCallerId extends Resource {

    private static final long serialVersionUID = 75956517535233L;

    public static OutgoingCallerIdDeleter deleter(final String pathSid) {
        return new OutgoingCallerIdDeleter(pathSid);
    }

    public static OutgoingCallerIdDeleter deleter(
        final String pathAccountSid,
        final String pathSid
    ) {
        return new OutgoingCallerIdDeleter(pathAccountSid, pathSid);
    }

    public static OutgoingCallerIdFetcher fetcher(final String pathSid) {
        return new OutgoingCallerIdFetcher(pathSid);
    }

    public static OutgoingCallerIdFetcher fetcher(
        final String pathAccountSid,
        final String pathSid
    ) {
        return new OutgoingCallerIdFetcher(pathAccountSid, pathSid);
    }

    public static OutgoingCallerIdReader reader() {
        return new OutgoingCallerIdReader();
    }

    public static OutgoingCallerIdReader reader(final String pathAccountSid) {
        return new OutgoingCallerIdReader(pathAccountSid);
    }

    public static OutgoingCallerIdUpdater updater(final String pathSid) {
        return new OutgoingCallerIdUpdater(pathSid);
    }

    public static OutgoingCallerIdUpdater updater(
        final String pathAccountSid,
        final String pathSid
    ) {
        return new OutgoingCallerIdUpdater(pathAccountSid, pathSid);
    }

    /**
     * Converts a JSON String into a OutgoingCallerId object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return OutgoingCallerId object represented by the provided JSON
     */
    public static OutgoingCallerId fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, OutgoingCallerId.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a OutgoingCallerId object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return OutgoingCallerId object represented by the provided JSON
     */
    public static OutgoingCallerId fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, OutgoingCallerId.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final String accountSid;
    private final com.twilio.type.PhoneNumber phoneNumber;
    private final String uri;

    @JsonCreator
    private OutgoingCallerId(
        @JsonProperty("sid") final String sid,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("friendly_name") final String friendlyName,
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty(
            "phone_number"
        ) final com.twilio.type.PhoneNumber phoneNumber,
        @JsonProperty("uri") final String uri
    ) {
        this.sid = sid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.accountSid = accountSid;
        this.phoneNumber = phoneNumber;
        this.uri = uri;
    }

    public final String getSid() {
        return this.sid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final com.twilio.type.PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getUri() {
        return this.uri;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        OutgoingCallerId other = (OutgoingCallerId) o;

        return (
            Objects.equals(sid, other.sid) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(friendlyName, other.friendlyName) &&
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(phoneNumber, other.phoneNumber) &&
            Objects.equals(uri, other.uri)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            sid,
            dateCreated,
            dateUpdated,
            friendlyName,
            accountSid,
            phoneNumber,
            uri
        );
    }
}
