/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Api
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Queue extends Resource {

    private static final long serialVersionUID = 17909156629067L;

    public static QueueCreator creator(final String friendlyName) {
        return new QueueCreator(friendlyName);
    }

    public static QueueCreator creator(
        final String pathAccountSid,
        final String friendlyName
    ) {
        return new QueueCreator(pathAccountSid, friendlyName);
    }

    public static QueueDeleter deleter(final String pathSid) {
        return new QueueDeleter(pathSid);
    }

    public static QueueDeleter deleter(
        final String pathAccountSid,
        final String pathSid
    ) {
        return new QueueDeleter(pathAccountSid, pathSid);
    }

    public static QueueFetcher fetcher(final String pathSid) {
        return new QueueFetcher(pathSid);
    }

    public static QueueFetcher fetcher(
        final String pathAccountSid,
        final String pathSid
    ) {
        return new QueueFetcher(pathAccountSid, pathSid);
    }

    public static QueueReader reader() {
        return new QueueReader();
    }

    public static QueueReader reader(final String pathAccountSid) {
        return new QueueReader(pathAccountSid);
    }

    public static QueueUpdater updater(final String pathSid) {
        return new QueueUpdater(pathSid);
    }

    public static QueueUpdater updater(
        final String pathAccountSid,
        final String pathSid
    ) {
        return new QueueUpdater(pathAccountSid, pathSid);
    }

    /**
     * Converts a JSON String into a Queue object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Queue object represented by the provided JSON
     */
    public static Queue fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Queue.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Queue object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Queue object represented by the provided JSON
     */
    public static Queue fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Queue.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final ZonedDateTime dateUpdated;
    private final Integer currentSize;
    private final String friendlyName;
    private final String uri;
    private final String accountSid;
    private final Integer averageWaitTime;
    private final String sid;
    private final ZonedDateTime dateCreated;
    private final Integer maxSize;

    @JsonCreator
    private Queue(
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("current_size") final Integer currentSize,
        @JsonProperty("friendly_name") final String friendlyName,
        @JsonProperty("uri") final String uri,
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("average_wait_time") final Integer averageWaitTime,
        @JsonProperty("sid") final String sid,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("max_size") final Integer maxSize
    ) {
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.currentSize = currentSize;
        this.friendlyName = friendlyName;
        this.uri = uri;
        this.accountSid = accountSid;
        this.averageWaitTime = averageWaitTime;
        this.sid = sid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.maxSize = maxSize;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Integer getCurrentSize() {
        return this.currentSize;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getUri() {
        return this.uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getAverageWaitTime() {
        return this.averageWaitTime;
    }

    public final String getSid() {
        return this.sid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final Integer getMaxSize() {
        return this.maxSize;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Queue other = (Queue) o;

        return (
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(currentSize, other.currentSize) &&
            Objects.equals(friendlyName, other.friendlyName) &&
            Objects.equals(uri, other.uri) &&
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(averageWaitTime, other.averageWaitTime) &&
            Objects.equals(sid, other.sid) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(maxSize, other.maxSize)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            dateUpdated,
            currentSize,
            friendlyName,
            uri,
            accountSid,
            averageWaitTime,
            sid,
            dateCreated,
            maxSize
        );
    }
}
