/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Api
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.api.v2010.account.queue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Member extends Resource {

    private static final long serialVersionUID = 196464556782918L;

    public static MemberFetcher fetcher(
        final String pathQueueSid,
        final String pathCallSid
    ) {
        return new MemberFetcher(pathQueueSid, pathCallSid);
    }

    public static MemberFetcher fetcher(
        final String pathAccountSid,
        final String pathQueueSid,
        final String pathCallSid
    ) {
        return new MemberFetcher(pathAccountSid, pathQueueSid, pathCallSid);
    }

    public static MemberReader reader(final String pathQueueSid) {
        return new MemberReader(pathQueueSid);
    }

    public static MemberReader reader(
        final String pathAccountSid,
        final String pathQueueSid
    ) {
        return new MemberReader(pathAccountSid, pathQueueSid);
    }

    public static MemberUpdater updater(
        final String pathQueueSid,
        final String pathCallSid,
        final URI url
    ) {
        return new MemberUpdater(pathQueueSid, pathCallSid, url);
    }

    public static MemberUpdater updater(
        final String pathAccountSid,
        final String pathQueueSid,
        final String pathCallSid,
        final URI url
    ) {
        return new MemberUpdater(
            pathAccountSid,
            pathQueueSid,
            pathCallSid,
            url
        );
    }

    /**
     * Converts a JSON String into a Member object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Member object represented by the provided JSON
     */
    public static Member fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Member.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Member object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Member object represented by the provided JSON
     */
    public static Member fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Member.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String callSid;
    private final ZonedDateTime dateEnqueued;
    private final Integer position;
    private final String uri;
    private final Integer waitTime;
    private final String queueSid;

    @JsonCreator
    private Member(
        @JsonProperty("call_sid") final String callSid,
        @JsonProperty("date_enqueued") final String dateEnqueued,
        @JsonProperty("position") final Integer position,
        @JsonProperty("uri") final String uri,
        @JsonProperty("wait_time") final Integer waitTime,
        @JsonProperty("queue_sid") final String queueSid
    ) {
        this.callSid = callSid;
        this.dateEnqueued =
            DateConverter.rfc2822DateTimeFromString(dateEnqueued);
        this.position = position;
        this.uri = uri;
        this.waitTime = waitTime;
        this.queueSid = queueSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final ZonedDateTime getDateEnqueued() {
        return this.dateEnqueued;
    }

    public final Integer getPosition() {
        return this.position;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Integer getWaitTime() {
        return this.waitTime;
    }

    public final String getQueueSid() {
        return this.queueSid;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Member other = (Member) o;

        return (
            Objects.equals(callSid, other.callSid) &&
            Objects.equals(dateEnqueued, other.dateEnqueued) &&
            Objects.equals(position, other.position) &&
            Objects.equals(uri, other.uri) &&
            Objects.equals(waitTime, other.waitTime) &&
            Objects.equals(queueSid, other.queueSid)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            callSid,
            dateEnqueued,
            position,
            uri,
            waitTime,
            queueSid
        );
    }
}
