/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Api
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.api.v2010.account.recording;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class AddOnResult extends Resource {

    private static final long serialVersionUID = 121199532836736L;

    public static AddOnResultDeleter deleter(
        final String pathReferenceSid,
        final String pathSid
    ) {
        return new AddOnResultDeleter(pathReferenceSid, pathSid);
    }

    public static AddOnResultDeleter deleter(
        final String pathAccountSid,
        final String pathReferenceSid,
        final String pathSid
    ) {
        return new AddOnResultDeleter(
            pathAccountSid,
            pathReferenceSid,
            pathSid
        );
    }

    public static AddOnResultFetcher fetcher(
        final String pathReferenceSid,
        final String pathSid
    ) {
        return new AddOnResultFetcher(pathReferenceSid, pathSid);
    }

    public static AddOnResultFetcher fetcher(
        final String pathAccountSid,
        final String pathReferenceSid,
        final String pathSid
    ) {
        return new AddOnResultFetcher(
            pathAccountSid,
            pathReferenceSid,
            pathSid
        );
    }

    public static AddOnResultReader reader(final String pathReferenceSid) {
        return new AddOnResultReader(pathReferenceSid);
    }

    public static AddOnResultReader reader(
        final String pathAccountSid,
        final String pathReferenceSid
    ) {
        return new AddOnResultReader(pathAccountSid, pathReferenceSid);
    }

    /**
     * Converts a JSON String into a AddOnResult object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return AddOnResult object represented by the provided JSON
     */
    public static AddOnResult fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, AddOnResult.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a AddOnResult object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return AddOnResult object represented by the provided JSON
     */
    public static AddOnResult fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, AddOnResult.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public enum Status {
        CANCELED("canceled"),
        COMPLETED("completed"),
        DELETED("deleted"),
        FAILED("failed"),
        IN_PROGRESS("in-progress"),
        INIT("init"),
        PROCESSING("processing"),
        QUEUED("queued");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    private final String sid;
    private final String accountSid;
    private final AddOnResult.Status status;
    private final String addOnSid;
    private final String addOnConfigurationSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final ZonedDateTime dateCompleted;
    private final String referenceSid;
    private final Map<String, String> subresourceUris;

    @JsonCreator
    private AddOnResult(
        @JsonProperty("sid") final String sid,
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("status") final AddOnResult.Status status,
        @JsonProperty("add_on_sid") final String addOnSid,
        @JsonProperty(
            "add_on_configuration_sid"
        ) final String addOnConfigurationSid,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("date_completed") final String dateCompleted,
        @JsonProperty("reference_sid") final String referenceSid,
        @JsonProperty("subresource_uris") final Map<
            String,
            String
        > subresourceUris
    ) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.status = status;
        this.addOnSid = addOnSid;
        this.addOnConfigurationSid = addOnConfigurationSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.dateCompleted =
            DateConverter.rfc2822DateTimeFromString(dateCompleted);
        this.referenceSid = referenceSid;
        this.subresourceUris = subresourceUris;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final AddOnResult.Status getStatus() {
        return this.status;
    }

    public final String getAddOnSid() {
        return this.addOnSid;
    }

    public final String getAddOnConfigurationSid() {
        return this.addOnConfigurationSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final ZonedDateTime getDateCompleted() {
        return this.dateCompleted;
    }

    public final String getReferenceSid() {
        return this.referenceSid;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AddOnResult other = (AddOnResult) o;

        return (
            Objects.equals(sid, other.sid) &&
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(status, other.status) &&
            Objects.equals(addOnSid, other.addOnSid) &&
            Objects.equals(
                addOnConfigurationSid,
                other.addOnConfigurationSid
            ) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(dateCompleted, other.dateCompleted) &&
            Objects.equals(referenceSid, other.referenceSid) &&
            Objects.equals(subresourceUris, other.subresourceUris)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            sid,
            accountSid,
            status,
            addOnSid,
            addOnConfigurationSid,
            dateCreated,
            dateUpdated,
            dateCompleted,
            referenceSid,
            subresourceUris
        );
    }
}
