/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Api
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.api.v2010.account.recording.addonresult;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Payload extends Resource {

    private static final long serialVersionUID = 241774798598483L;

    public static PayloadDeleter deleter(
        final String pathReferenceSid,
        final String pathAddOnResultSid,
        final String pathSid
    ) {
        return new PayloadDeleter(
            pathReferenceSid,
            pathAddOnResultSid,
            pathSid
        );
    }

    public static PayloadDeleter deleter(
        final String pathAccountSid,
        final String pathReferenceSid,
        final String pathAddOnResultSid,
        final String pathSid
    ) {
        return new PayloadDeleter(
            pathAccountSid,
            pathReferenceSid,
            pathAddOnResultSid,
            pathSid
        );
    }

    public static PayloadFetcher fetcher(
        final String pathReferenceSid,
        final String pathAddOnResultSid,
        final String pathSid
    ) {
        return new PayloadFetcher(
            pathReferenceSid,
            pathAddOnResultSid,
            pathSid
        );
    }

    public static PayloadFetcher fetcher(
        final String pathAccountSid,
        final String pathReferenceSid,
        final String pathAddOnResultSid,
        final String pathSid
    ) {
        return new PayloadFetcher(
            pathAccountSid,
            pathReferenceSid,
            pathAddOnResultSid,
            pathSid
        );
    }

    public static PayloadReader reader(
        final String pathReferenceSid,
        final String pathAddOnResultSid
    ) {
        return new PayloadReader(pathReferenceSid, pathAddOnResultSid);
    }

    public static PayloadReader reader(
        final String pathAccountSid,
        final String pathReferenceSid,
        final String pathAddOnResultSid
    ) {
        return new PayloadReader(
            pathAccountSid,
            pathReferenceSid,
            pathAddOnResultSid
        );
    }

    /**
     * Converts a JSON String into a Payload object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Payload object represented by the provided JSON
     */
    public static Payload fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Payload.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Payload object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Payload object represented by the provided JSON
     */
    public static Payload fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Payload.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String addOnResultSid;
    private final String accountSid;
    private final String label;
    private final String addOnSid;
    private final String addOnConfigurationSid;
    private final String contentType;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String referenceSid;
    private final Map<String, String> subresourceUris;

    @JsonCreator
    private Payload(
        @JsonProperty("sid") final String sid,
        @JsonProperty("add_on_result_sid") final String addOnResultSid,
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("label") final String label,
        @JsonProperty("add_on_sid") final String addOnSid,
        @JsonProperty(
            "add_on_configuration_sid"
        ) final String addOnConfigurationSid,
        @JsonProperty("content_type") final String contentType,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("reference_sid") final String referenceSid,
        @JsonProperty("subresource_uris") final Map<
            String,
            String
        > subresourceUris
    ) {
        this.sid = sid;
        this.addOnResultSid = addOnResultSid;
        this.accountSid = accountSid;
        this.label = label;
        this.addOnSid = addOnSid;
        this.addOnConfigurationSid = addOnConfigurationSid;
        this.contentType = contentType;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.referenceSid = referenceSid;
        this.subresourceUris = subresourceUris;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAddOnResultSid() {
        return this.addOnResultSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getAddOnSid() {
        return this.addOnSid;
    }

    public final String getAddOnConfigurationSid() {
        return this.addOnConfigurationSid;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getReferenceSid() {
        return this.referenceSid;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Payload other = (Payload) o;

        return (
            Objects.equals(sid, other.sid) &&
            Objects.equals(addOnResultSid, other.addOnResultSid) &&
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(label, other.label) &&
            Objects.equals(addOnSid, other.addOnSid) &&
            Objects.equals(
                addOnConfigurationSid,
                other.addOnConfigurationSid
            ) &&
            Objects.equals(contentType, other.contentType) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(referenceSid, other.referenceSid) &&
            Objects.equals(subresourceUris, other.subresourceUris)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            sid,
            addOnResultSid,
            accountSid,
            label,
            addOnSid,
            addOnConfigurationSid,
            contentType,
            dateCreated,
            dateUpdated,
            referenceSid,
            subresourceUris
        );
    }
}
