/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Api
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class IpAddress extends Resource {

    private static final long serialVersionUID = 125766891149812L;

    public static IpAddressCreator creator(
        final String pathIpAccessControlListSid,
        final String friendlyName,
        final String ipAddress
    ) {
        return new IpAddressCreator(
            pathIpAccessControlListSid,
            friendlyName,
            ipAddress
        );
    }

    public static IpAddressCreator creator(
        final String pathAccountSid,
        final String pathIpAccessControlListSid,
        final String friendlyName,
        final String ipAddress
    ) {
        return new IpAddressCreator(
            pathAccountSid,
            pathIpAccessControlListSid,
            friendlyName,
            ipAddress
        );
    }

    public static IpAddressDeleter deleter(
        final String pathIpAccessControlListSid,
        final String pathSid
    ) {
        return new IpAddressDeleter(pathIpAccessControlListSid, pathSid);
    }

    public static IpAddressDeleter deleter(
        final String pathAccountSid,
        final String pathIpAccessControlListSid,
        final String pathSid
    ) {
        return new IpAddressDeleter(
            pathAccountSid,
            pathIpAccessControlListSid,
            pathSid
        );
    }

    public static IpAddressFetcher fetcher(
        final String pathIpAccessControlListSid,
        final String pathSid
    ) {
        return new IpAddressFetcher(pathIpAccessControlListSid, pathSid);
    }

    public static IpAddressFetcher fetcher(
        final String pathAccountSid,
        final String pathIpAccessControlListSid,
        final String pathSid
    ) {
        return new IpAddressFetcher(
            pathAccountSid,
            pathIpAccessControlListSid,
            pathSid
        );
    }

    public static IpAddressReader reader(
        final String pathIpAccessControlListSid
    ) {
        return new IpAddressReader(pathIpAccessControlListSid);
    }

    public static IpAddressReader reader(
        final String pathAccountSid,
        final String pathIpAccessControlListSid
    ) {
        return new IpAddressReader(pathAccountSid, pathIpAccessControlListSid);
    }

    public static IpAddressUpdater updater(
        final String pathIpAccessControlListSid,
        final String pathSid
    ) {
        return new IpAddressUpdater(pathIpAccessControlListSid, pathSid);
    }

    public static IpAddressUpdater updater(
        final String pathAccountSid,
        final String pathIpAccessControlListSid,
        final String pathSid
    ) {
        return new IpAddressUpdater(
            pathAccountSid,
            pathIpAccessControlListSid,
            pathSid
        );
    }

    /**
     * Converts a JSON String into a IpAddress object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return IpAddress object represented by the provided JSON
     */
    public static IpAddress fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, IpAddress.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a IpAddress object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return IpAddress object represented by the provided JSON
     */
    public static IpAddress fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, IpAddress.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final String ipAddress;
    private final Integer cidrPrefixLength;
    private final String ipAccessControlListSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String uri;

    @JsonCreator
    private IpAddress(
        @JsonProperty("sid") final String sid,
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("friendly_name") final String friendlyName,
        @JsonProperty("ip_address") final String ipAddress,
        @JsonProperty("cidr_prefix_length") final Integer cidrPrefixLength,
        @JsonProperty(
            "ip_access_control_list_sid"
        ) final String ipAccessControlListSid,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("uri") final String uri
    ) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.ipAddress = ipAddress;
        this.cidrPrefixLength = cidrPrefixLength;
        this.ipAccessControlListSid = ipAccessControlListSid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.uri = uri;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIpAddress() {
        return this.ipAddress;
    }

    public final Integer getCidrPrefixLength() {
        return this.cidrPrefixLength;
    }

    public final String getIpAccessControlListSid() {
        return this.ipAccessControlListSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getUri() {
        return this.uri;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        IpAddress other = (IpAddress) o;

        return (
            Objects.equals(sid, other.sid) &&
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(friendlyName, other.friendlyName) &&
            Objects.equals(ipAddress, other.ipAddress) &&
            Objects.equals(cidrPrefixLength, other.cidrPrefixLength) &&
            Objects.equals(
                ipAccessControlListSid,
                other.ipAccessControlListSid
            ) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(uri, other.uri)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            sid,
            accountSid,
            friendlyName,
            ipAddress,
            cidrPrefixLength,
            ipAccessControlListSid,
            dateCreated,
            dateUpdated,
            uri
        );
    }
}
