/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Conversations
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.conversations.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class ConfigurationUpdater extends Updater<Configuration> {

    private String defaultChatServiceSid;
    private String defaultMessagingServiceSid;
    private String defaultInactiveTimer;
    private String defaultClosedTimer;

    public ConfigurationUpdater() {}

    public ConfigurationUpdater setDefaultChatServiceSid(
        final String defaultChatServiceSid
    ) {
        this.defaultChatServiceSid = defaultChatServiceSid;
        return this;
    }

    public ConfigurationUpdater setDefaultMessagingServiceSid(
        final String defaultMessagingServiceSid
    ) {
        this.defaultMessagingServiceSid = defaultMessagingServiceSid;
        return this;
    }

    public ConfigurationUpdater setDefaultInactiveTimer(
        final String defaultInactiveTimer
    ) {
        this.defaultInactiveTimer = defaultInactiveTimer;
        return this;
    }

    public ConfigurationUpdater setDefaultClosedTimer(
        final String defaultClosedTimer
    ) {
        this.defaultClosedTimer = defaultClosedTimer;
        return this;
    }

    @Override
    public Configuration update(final TwilioRestClient client) {
        String path = "/v1/Configuration";

        Request request = new Request(
            HttpMethod.POST,
            Domains.CONVERSATIONS.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "Configuration update failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return Configuration.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }

    private void addPostParams(final Request request) {
        if (defaultChatServiceSid != null) {
            request.addPostParam(
                "DefaultChatServiceSid",
                defaultChatServiceSid
            );
        }
        if (defaultMessagingServiceSid != null) {
            request.addPostParam(
                "DefaultMessagingServiceSid",
                defaultMessagingServiceSid
            );
        }
        if (defaultInactiveTimer != null) {
            request.addPostParam("DefaultInactiveTimer", defaultInactiveTimer);
        }
        if (defaultClosedTimer != null) {
            request.addPostParam("DefaultClosedTimer", defaultClosedTimer);
        }
    }
}
