/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Conversations
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.conversations.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Configuration extends Resource {

    private static final long serialVersionUID = 35465460450497L;

    public static ConfigurationFetcher fetcher(
        final String pathChatServiceSid
    ) {
        return new ConfigurationFetcher(pathChatServiceSid);
    }

    public static ConfigurationUpdater updater(
        final String pathChatServiceSid
    ) {
        return new ConfigurationUpdater(pathChatServiceSid);
    }

    /**
     * Converts a JSON String into a Configuration object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Configuration object represented by the provided JSON
     */
    public static Configuration fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Configuration.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Configuration object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Configuration object represented by the provided JSON
     */
    public static Configuration fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Configuration.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String chatServiceSid;
    private final String defaultConversationCreatorRoleSid;
    private final String defaultConversationRoleSid;
    private final String defaultChatServiceRoleSid;
    private final URI url;
    private final Map<String, String> links;
    private final Boolean reachabilityEnabled;

    @JsonCreator
    private Configuration(
        @JsonProperty("chat_service_sid") final String chatServiceSid,
        @JsonProperty(
            "default_conversation_creator_role_sid"
        ) final String defaultConversationCreatorRoleSid,
        @JsonProperty(
            "default_conversation_role_sid"
        ) final String defaultConversationRoleSid,
        @JsonProperty(
            "default_chat_service_role_sid"
        ) final String defaultChatServiceRoleSid,
        @JsonProperty("url") final URI url,
        @JsonProperty("links") final Map<String, String> links,
        @JsonProperty("reachability_enabled") final Boolean reachabilityEnabled
    ) {
        this.chatServiceSid = chatServiceSid;
        this.defaultConversationCreatorRoleSid =
            defaultConversationCreatorRoleSid;
        this.defaultConversationRoleSid = defaultConversationRoleSid;
        this.defaultChatServiceRoleSid = defaultChatServiceRoleSid;
        this.url = url;
        this.links = links;
        this.reachabilityEnabled = reachabilityEnabled;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final String getDefaultConversationCreatorRoleSid() {
        return this.defaultConversationCreatorRoleSid;
    }

    public final String getDefaultConversationRoleSid() {
        return this.defaultConversationRoleSid;
    }

    public final String getDefaultChatServiceRoleSid() {
        return this.defaultChatServiceRoleSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final Boolean getReachabilityEnabled() {
        return this.reachabilityEnabled;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Configuration other = (Configuration) o;

        return (
            Objects.equals(chatServiceSid, other.chatServiceSid) &&
            Objects.equals(
                defaultConversationCreatorRoleSid,
                other.defaultConversationCreatorRoleSid
            ) &&
            Objects.equals(
                defaultConversationRoleSid,
                other.defaultConversationRoleSid
            ) &&
            Objects.equals(
                defaultChatServiceRoleSid,
                other.defaultChatServiceRoleSid
            ) &&
            Objects.equals(url, other.url) &&
            Objects.equals(links, other.links) &&
            Objects.equals(reachabilityEnabled, other.reachabilityEnabled)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            chatServiceSid,
            defaultConversationCreatorRoleSid,
            defaultConversationRoleSid,
            defaultChatServiceRoleSid,
            url,
            links,
            reachabilityEnabled
        );
    }
}
