/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Events
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.events.v1.schema;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class SchemaVersionFetcher extends Fetcher<SchemaVersion> {

    private String pathId;
    private Integer pathSchemaVersion;

    public SchemaVersionFetcher(
        final String pathId,
        final Integer pathSchemaVersion
    ) {
        this.pathId = pathId;
        this.pathSchemaVersion = pathSchemaVersion;
    }

    @Override
    public SchemaVersion fetch(final TwilioRestClient client) {
        String path = "/v1/Schemas/{Id}/Versions/{SchemaVersion}";

        path = path.replace("{" + "Id" + "}", this.pathId.toString());
        path =
            path.replace(
                "{" + "SchemaVersion" + "}",
                this.pathSchemaVersion.toString()
            );

        Request request = new Request(
            HttpMethod.GET,
            Domains.EVENTS.toString(),
            path
        );
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException(
                "SchemaVersion fetch failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return SchemaVersion.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }
}
