/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class InsightsAssessmentsComment extends Resource {

    private static final long serialVersionUID = 175598645429423L;

    public static InsightsAssessmentsCommentCreator creator(
        final String categoryId,
        final String categoryName,
        final String comment,
        final String segmentId,
        final String agentId,
        final BigDecimal offset
    ) {
        return new InsightsAssessmentsCommentCreator(
            categoryId,
            categoryName,
            comment,
            segmentId,
            agentId,
            offset
        );
    }

    public static InsightsAssessmentsCommentReader reader() {
        return new InsightsAssessmentsCommentReader();
    }

    /**
     * Converts a JSON String into a InsightsAssessmentsComment object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return InsightsAssessmentsComment object represented by the provided JSON
     */
    public static InsightsAssessmentsComment fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(
                json,
                InsightsAssessmentsComment.class
            );
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a InsightsAssessmentsComment object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return InsightsAssessmentsComment object represented by the provided JSON
     */
    public static InsightsAssessmentsComment fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(
                json,
                InsightsAssessmentsComment.class
            );
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String assessmentSid;
    private final Map<String, Object> comment;
    private final BigDecimal offset;
    private final Boolean report;
    private final BigDecimal weight;
    private final String agentId;
    private final String segmentId;
    private final String userName;
    private final String userEmail;
    private final BigDecimal timestamp;
    private final URI url;

    @JsonCreator
    private InsightsAssessmentsComment(
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("assessment_sid") final String assessmentSid,
        @JsonProperty("comment") final Map<String, Object> comment,
        @JsonProperty("offset") final BigDecimal offset,
        @JsonProperty("report") final Boolean report,
        @JsonProperty("weight") final BigDecimal weight,
        @JsonProperty("agent_id") final String agentId,
        @JsonProperty("segment_id") final String segmentId,
        @JsonProperty("user_name") final String userName,
        @JsonProperty("user_email") final String userEmail,
        @JsonProperty("timestamp") final BigDecimal timestamp,
        @JsonProperty("url") final URI url
    ) {
        this.accountSid = accountSid;
        this.assessmentSid = assessmentSid;
        this.comment = comment;
        this.offset = offset;
        this.report = report;
        this.weight = weight;
        this.agentId = agentId;
        this.segmentId = segmentId;
        this.userName = userName;
        this.userEmail = userEmail;
        this.timestamp = timestamp;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAssessmentSid() {
        return this.assessmentSid;
    }

    public final Map<String, Object> getComment() {
        return this.comment;
    }

    public final BigDecimal getOffset() {
        return this.offset;
    }

    public final Boolean getReport() {
        return this.report;
    }

    public final BigDecimal getWeight() {
        return this.weight;
    }

    public final String getAgentId() {
        return this.agentId;
    }

    public final String getSegmentId() {
        return this.segmentId;
    }

    public final String getUserName() {
        return this.userName;
    }

    public final String getUserEmail() {
        return this.userEmail;
    }

    public final BigDecimal getTimestamp() {
        return this.timestamp;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        InsightsAssessmentsComment other = (InsightsAssessmentsComment) o;

        return (
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(assessmentSid, other.assessmentSid) &&
            Objects.equals(comment, other.comment) &&
            Objects.equals(offset, other.offset) &&
            Objects.equals(report, other.report) &&
            Objects.equals(weight, other.weight) &&
            Objects.equals(agentId, other.agentId) &&
            Objects.equals(segmentId, other.segmentId) &&
            Objects.equals(userName, other.userName) &&
            Objects.equals(userEmail, other.userEmail) &&
            Objects.equals(timestamp, other.timestamp) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            accountSid,
            assessmentSid,
            comment,
            offset,
            report,
            weight,
            agentId,
            segmentId,
            userName,
            userEmail,
            timestamp,
            url
        );
    }
}
