/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Frontline
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.frontlineapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class User extends Resource {

    private static final long serialVersionUID = 253333531578389L;

    public static UserFetcher fetcher(final String pathSid) {
        return new UserFetcher(pathSid);
    }

    public static UserUpdater updater(final String pathSid) {
        return new UserUpdater(pathSid);
    }

    /**
     * Converts a JSON String into a User object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return User object represented by the provided JSON
     */
    public static User fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, User.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a User object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return User object represented by the provided JSON
     */
    public static User fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, User.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public enum StateType {
        ACTIVE("active"),
        DEACTIVATED("deactivated");

        private final String value;

        private StateType(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static StateType forValue(final String value) {
            return Promoter.enumFromString(value, StateType.values());
        }
    }

    private final String sid;
    private final String identity;
    private final String friendlyName;
    private final String avatar;
    private final User.StateType state;
    private final Boolean isAvailable;
    private final URI url;

    @JsonCreator
    private User(
        @JsonProperty("sid") final String sid,
        @JsonProperty("identity") final String identity,
        @JsonProperty("friendly_name") final String friendlyName,
        @JsonProperty("avatar") final String avatar,
        @JsonProperty("state") final User.StateType state,
        @JsonProperty("is_available") final Boolean isAvailable,
        @JsonProperty("url") final URI url
    ) {
        this.sid = sid;
        this.identity = identity;
        this.friendlyName = friendlyName;
        this.avatar = avatar;
        this.state = state;
        this.isAvailable = isAvailable;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getAvatar() {
        return this.avatar;
    }

    public final User.StateType getState() {
        return this.state;
    }

    public final Boolean getIsAvailable() {
        return this.isAvailable;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        User other = (User) o;

        return (
            Objects.equals(sid, other.sid) &&
            Objects.equals(identity, other.identity) &&
            Objects.equals(friendlyName, other.friendlyName) &&
            Objects.equals(avatar, other.avatar) &&
            Objects.equals(state, other.state) &&
            Objects.equals(isAvailable, other.isAvailable) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            sid,
            identity,
            friendlyName,
            avatar,
            state,
            isAvailable,
            url
        );
    }
}
