/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Insights
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.insights.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class SettingUpdater extends Updater<Setting> {

    private Boolean advancedFeatures;
    private Boolean voiceTrace;
    private String subaccountSid;

    public SettingUpdater() {}

    public SettingUpdater setAdvancedFeatures(final Boolean advancedFeatures) {
        this.advancedFeatures = advancedFeatures;
        return this;
    }

    public SettingUpdater setVoiceTrace(final Boolean voiceTrace) {
        this.voiceTrace = voiceTrace;
        return this;
    }

    public SettingUpdater setSubaccountSid(final String subaccountSid) {
        this.subaccountSid = subaccountSid;
        return this;
    }

    @Override
    public Setting update(final TwilioRestClient client) {
        String path = "/v1/Voice/Settings";

        Request request = new Request(
            HttpMethod.POST,
            Domains.INSIGHTS.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "Setting update failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return Setting.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(final Request request) {
        if (advancedFeatures != null) {
            request.addPostParam(
                "AdvancedFeatures",
                advancedFeatures.toString()
            );
        }
        if (voiceTrace != null) {
            request.addPostParam("VoiceTrace", voiceTrace.toString());
        }
        if (subaccountSid != null) {
            request.addPostParam("SubaccountSid", subaccountSid);
        }
    }
}
