/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Intelligence
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.intelligence.v2;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Map;

public class TranscriptCreator extends Creator<Transcript> {

    private String serviceSid;
    private Map<String, Object> channel;
    private String customerKey;
    private ZonedDateTime mediaStartTime;

    public TranscriptCreator(
        final String serviceSid,
        final Map<String, Object> channel
    ) {
        this.serviceSid = serviceSid;
        this.channel = channel;
    }

    public TranscriptCreator setServiceSid(final String serviceSid) {
        this.serviceSid = serviceSid;
        return this;
    }

    public TranscriptCreator setChannel(final Map<String, Object> channel) {
        this.channel = channel;
        return this;
    }

    public TranscriptCreator setCustomerKey(final String customerKey) {
        this.customerKey = customerKey;
        return this;
    }

    public TranscriptCreator setMediaStartTime(
        final ZonedDateTime mediaStartTime
    ) {
        this.mediaStartTime = mediaStartTime;
        return this;
    }

    @Override
    public Transcript create(final TwilioRestClient client) {
        String path = "/v2/Transcripts";

        path =
            path.replace("{" + "ServiceSid" + "}", this.serviceSid.toString());
        path = path.replace("{" + "Channel" + "}", this.channel.toString());

        Request request = new Request(
            HttpMethod.POST,
            Domains.INTELLIGENCE.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "Transcript creation failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return Transcript.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }

    private void addPostParams(final Request request) {
        if (serviceSid != null) {
            request.addPostParam("ServiceSid", serviceSid);
        }
        if (channel != null) {
            request.addPostParam("Channel", Converter.mapToJson(channel));
        }
        if (customerKey != null) {
            request.addPostParam("CustomerKey", customerKey);
        }
        if (mediaStartTime != null) {
            request.addPostParam(
                "MediaStartTime",
                mediaStartTime.toInstant().toString()
            );
        }
    }
}
