/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Intelligence
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.intelligence.v2;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class TranscriptReader extends Reader<Transcript> {

    private String serviceSid;
    private String beforeStartTime;
    private String afterStartTime;
    private String beforeDateCreated;
    private String afterDateCreated;
    private String status;
    private String languageCode;
    private String sourceSid;
    private Integer pageSize;

    public TranscriptReader() {}

    public TranscriptReader setServiceSid(final String serviceSid) {
        this.serviceSid = serviceSid;
        return this;
    }

    public TranscriptReader setBeforeStartTime(final String beforeStartTime) {
        this.beforeStartTime = beforeStartTime;
        return this;
    }

    public TranscriptReader setAfterStartTime(final String afterStartTime) {
        this.afterStartTime = afterStartTime;
        return this;
    }

    public TranscriptReader setBeforeDateCreated(
        final String beforeDateCreated
    ) {
        this.beforeDateCreated = beforeDateCreated;
        return this;
    }

    public TranscriptReader setAfterDateCreated(final String afterDateCreated) {
        this.afterDateCreated = afterDateCreated;
        return this;
    }

    public TranscriptReader setStatus(final String status) {
        this.status = status;
        return this;
    }

    public TranscriptReader setLanguageCode(final String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    public TranscriptReader setSourceSid(final String sourceSid) {
        this.sourceSid = sourceSid;
        return this;
    }

    public TranscriptReader setPageSize(final Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Transcript> read(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    public Page<Transcript> firstPage(final TwilioRestClient client) {
        String path = "/v2/Transcripts";

        Request request = new Request(
            HttpMethod.GET,
            Domains.INTELLIGENCE.toString(),
            path
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    private Page<Transcript> pageForRequest(
        final TwilioRestClient client,
        final Request request
    ) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException(
                "Transcript read failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return Page.fromJson(
            "transcripts",
            response.getContent(),
            Transcript.class,
            client.getObjectMapper()
        );
    }

    @Override
    public Page<Transcript> previousPage(
        final Page<Transcript> page,
        final TwilioRestClient client
    ) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(Domains.INTELLIGENCE.toString())
        );
        return pageForRequest(client, request);
    }

    @Override
    public Page<Transcript> nextPage(
        final Page<Transcript> page,
        final TwilioRestClient client
    ) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(Domains.INTELLIGENCE.toString())
        );
        return pageForRequest(client, request);
    }

    @Override
    public Page<Transcript> getPage(
        final String targetUrl,
        final TwilioRestClient client
    ) {
        Request request = new Request(HttpMethod.GET, targetUrl);

        return pageForRequest(client, request);
    }

    private void addQueryParams(final Request request) {
        if (serviceSid != null) {
            request.addQueryParam("ServiceSid", serviceSid);
        }
        if (beforeStartTime != null) {
            request.addQueryParam("BeforeStartTime", beforeStartTime);
        }
        if (afterStartTime != null) {
            request.addQueryParam("AfterStartTime", afterStartTime);
        }
        if (beforeDateCreated != null) {
            request.addQueryParam("BeforeDateCreated", beforeDateCreated);
        }
        if (afterDateCreated != null) {
            request.addQueryParam("AfterDateCreated", afterDateCreated);
        }
        if (status != null) {
            request.addQueryParam("Status", status);
        }
        if (languageCode != null) {
            request.addQueryParam("LanguageCode", languageCode);
        }
        if (sourceSid != null) {
            request.addQueryParam("SourceSid", sourceSid);
        }
        if (pageSize != null) {
            request.addQueryParam("PageSize", pageSize.toString());
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}
