/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Intelligence
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.intelligence.v2.transcript;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class OperatorResult extends Resource {

    private static final long serialVersionUID = 126254553573605L;

    public static OperatorResultFetcher fetcher(
        final String pathTranscriptSid,
        final String pathOperatorSid
    ) {
        return new OperatorResultFetcher(pathTranscriptSid, pathOperatorSid);
    }

    public static OperatorResultReader reader(final String pathTranscriptSid) {
        return new OperatorResultReader(pathTranscriptSid);
    }

    /**
     * Converts a JSON String into a OperatorResult object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return OperatorResult object represented by the provided JSON
     */
    public static OperatorResult fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, OperatorResult.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a OperatorResult object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return OperatorResult object represented by the provided JSON
     */
    public static OperatorResult fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, OperatorResult.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public enum OperatorType {
        CONVERSATION_CLASSIFY("conversation_classify"),
        UTTERANCE_CLASSIFY("utterance_classify"),
        EXTRACT("extract"),
        EXTRACT_NORMALIZE("extract_normalize"),
        PII_EXTRACT("pii_extract");

        private final String value;

        private OperatorType(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static OperatorType forValue(final String value) {
            return Promoter.enumFromString(value, OperatorType.values());
        }
    }

    private final OperatorResult.OperatorType operatorType;
    private final String name;
    private final String operatorSid;
    private final Boolean extractMatch;
    private final BigDecimal matchProbability;
    private final String normalizedResult;
    private final List<Map<String, Object>> utteranceResults;
    private final Boolean utteranceMatch;
    private final String predictedLabel;
    private final BigDecimal predictedProbability;
    private final Map<String, Object> labelProbabilities;
    private final Map<String, Object> extractResults;
    private final String transcriptSid;
    private final URI url;

    @JsonCreator
    private OperatorResult(
        @JsonProperty(
            "operator_type"
        ) final OperatorResult.OperatorType operatorType,
        @JsonProperty("name") final String name,
        @JsonProperty("operator_sid") final String operatorSid,
        @JsonProperty("extract_match") final Boolean extractMatch,
        @JsonProperty("match_probability") final BigDecimal matchProbability,
        @JsonProperty("normalized_result") final String normalizedResult,
        @JsonProperty("utterance_results") final List<
            Map<String, Object>
        > utteranceResults,
        @JsonProperty("utterance_match") final Boolean utteranceMatch,
        @JsonProperty("predicted_label") final String predictedLabel,
        @JsonProperty(
            "predicted_probability"
        ) final BigDecimal predictedProbability,
        @JsonProperty("label_probabilities") final Map<
            String,
            Object
        > labelProbabilities,
        @JsonProperty("extract_results") final Map<
            String,
            Object
        > extractResults,
        @JsonProperty("transcript_sid") final String transcriptSid,
        @JsonProperty("url") final URI url
    ) {
        this.operatorType = operatorType;
        this.name = name;
        this.operatorSid = operatorSid;
        this.extractMatch = extractMatch;
        this.matchProbability = matchProbability;
        this.normalizedResult = normalizedResult;
        this.utteranceResults = utteranceResults;
        this.utteranceMatch = utteranceMatch;
        this.predictedLabel = predictedLabel;
        this.predictedProbability = predictedProbability;
        this.labelProbabilities = labelProbabilities;
        this.extractResults = extractResults;
        this.transcriptSid = transcriptSid;
        this.url = url;
    }

    public final OperatorResult.OperatorType getOperatorType() {
        return this.operatorType;
    }

    public final String getName() {
        return this.name;
    }

    public final String getOperatorSid() {
        return this.operatorSid;
    }

    public final Boolean getExtractMatch() {
        return this.extractMatch;
    }

    public final BigDecimal getMatchProbability() {
        return this.matchProbability;
    }

    public final String getNormalizedResult() {
        return this.normalizedResult;
    }

    public final List<Map<String, Object>> getUtteranceResults() {
        return this.utteranceResults;
    }

    public final Boolean getUtteranceMatch() {
        return this.utteranceMatch;
    }

    public final String getPredictedLabel() {
        return this.predictedLabel;
    }

    public final BigDecimal getPredictedProbability() {
        return this.predictedProbability;
    }

    public final Map<String, Object> getLabelProbabilities() {
        return this.labelProbabilities;
    }

    public final Map<String, Object> getExtractResults() {
        return this.extractResults;
    }

    public final String getTranscriptSid() {
        return this.transcriptSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        OperatorResult other = (OperatorResult) o;

        return (
            Objects.equals(operatorType, other.operatorType) &&
            Objects.equals(name, other.name) &&
            Objects.equals(operatorSid, other.operatorSid) &&
            Objects.equals(extractMatch, other.extractMatch) &&
            Objects.equals(matchProbability, other.matchProbability) &&
            Objects.equals(normalizedResult, other.normalizedResult) &&
            Objects.equals(utteranceResults, other.utteranceResults) &&
            Objects.equals(utteranceMatch, other.utteranceMatch) &&
            Objects.equals(predictedLabel, other.predictedLabel) &&
            Objects.equals(predictedProbability, other.predictedProbability) &&
            Objects.equals(labelProbabilities, other.labelProbabilities) &&
            Objects.equals(extractResults, other.extractResults) &&
            Objects.equals(transcriptSid, other.transcriptSid) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            operatorType,
            name,
            operatorSid,
            extractMatch,
            matchProbability,
            normalizedResult,
            utteranceResults,
            utteranceMatch,
            predictedLabel,
            predictedProbability,
            labelProbabilities,
            extractResults,
            transcriptSid,
            url
        );
    }
}
