/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Intelligence
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.intelligence.v2.transcript;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class OperatorResultFetcher extends Fetcher<OperatorResult> {

    private String pathTranscriptSid;
    private String pathOperatorSid;
    private Boolean redacted;

    public OperatorResultFetcher(
        final String pathTranscriptSid,
        final String pathOperatorSid
    ) {
        this.pathTranscriptSid = pathTranscriptSid;
        this.pathOperatorSid = pathOperatorSid;
    }

    public OperatorResultFetcher setRedacted(final Boolean redacted) {
        this.redacted = redacted;
        return this;
    }

    @Override
    public OperatorResult fetch(final TwilioRestClient client) {
        String path =
            "/v2/Transcripts/{TranscriptSid}/OperatorResults/{OperatorSid}";

        path =
            path.replace(
                "{" + "TranscriptSid" + "}",
                this.pathTranscriptSid.toString()
            );
        path =
            path.replace(
                "{" + "OperatorSid" + "}",
                this.pathOperatorSid.toString()
            );

        Request request = new Request(
            HttpMethod.GET,
            Domains.INTELLIGENCE.toString(),
            path
        );
        addQueryParams(request);
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException(
                "OperatorResult fetch failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return OperatorResult.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }

    private void addQueryParams(final Request request) {
        if (redacted != null) {
            request.addQueryParam("Redacted", redacted.toString());
        }
    }
}
