/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Intelligence
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.intelligence.v2.transcript;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class OperatorResultReader extends Reader<OperatorResult> {

    private String pathTranscriptSid;
    private Boolean redacted;
    private Integer pageSize;

    public OperatorResultReader(final String pathTranscriptSid) {
        this.pathTranscriptSid = pathTranscriptSid;
    }

    public OperatorResultReader setRedacted(final Boolean redacted) {
        this.redacted = redacted;
        return this;
    }

    public OperatorResultReader setPageSize(final Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<OperatorResult> read(final TwilioRestClient client) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    public Page<OperatorResult> firstPage(final TwilioRestClient client) {
        String path = "/v2/Transcripts/{TranscriptSid}/OperatorResults";
        path =
            path.replace(
                "{" + "TranscriptSid" + "}",
                this.pathTranscriptSid.toString()
            );

        Request request = new Request(
            HttpMethod.GET,
            Domains.INTELLIGENCE.toString(),
            path
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    private Page<OperatorResult> pageForRequest(
        final TwilioRestClient client,
        final Request request
    ) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException(
                "OperatorResult read failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return Page.fromJson(
            "operator_results",
            response.getContent(),
            OperatorResult.class,
            client.getObjectMapper()
        );
    }

    @Override
    public Page<OperatorResult> previousPage(
        final Page<OperatorResult> page,
        final TwilioRestClient client
    ) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(Domains.INTELLIGENCE.toString())
        );
        return pageForRequest(client, request);
    }

    @Override
    public Page<OperatorResult> nextPage(
        final Page<OperatorResult> page,
        final TwilioRestClient client
    ) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(Domains.INTELLIGENCE.toString())
        );
        return pageForRequest(client, request);
    }

    @Override
    public Page<OperatorResult> getPage(
        final String targetUrl,
        final TwilioRestClient client
    ) {
        Request request = new Request(HttpMethod.GET, targetUrl);

        return pageForRequest(client, request);
    }

    private void addQueryParams(final Request request) {
        if (redacted != null) {
            request.addQueryParam("Redacted", redacted.toString());
        }
        if (pageSize != null) {
            request.addQueryParam("PageSize", pageSize.toString());
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}
