/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Intelligence
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.intelligence.v2.transcript;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Sentence extends Resource {

    private static final long serialVersionUID = 210633055908555L;

    public static SentenceReader reader(final String pathTranscriptSid) {
        return new SentenceReader(pathTranscriptSid);
    }

    /**
     * Converts a JSON String into a Sentence object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Sentence object represented by the provided JSON
     */
    public static Sentence fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Sentence.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Sentence object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Sentence object represented by the provided JSON
     */
    public static Sentence fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Sentence.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final Integer mediaChannel;
    private final Integer sentenceIndex;
    private final BigDecimal startTime;
    private final BigDecimal endTime;
    private final String transcript;
    private final String sid;
    private final BigDecimal confidence;

    @JsonCreator
    private Sentence(
        @JsonProperty("media_channel") final Integer mediaChannel,
        @JsonProperty("sentence_index") final Integer sentenceIndex,
        @JsonProperty("start_time") final BigDecimal startTime,
        @JsonProperty("end_time") final BigDecimal endTime,
        @JsonProperty("transcript") final String transcript,
        @JsonProperty("sid") final String sid,
        @JsonProperty("confidence") final BigDecimal confidence
    ) {
        this.mediaChannel = mediaChannel;
        this.sentenceIndex = sentenceIndex;
        this.startTime = startTime;
        this.endTime = endTime;
        this.transcript = transcript;
        this.sid = sid;
        this.confidence = confidence;
    }

    public final Integer getMediaChannel() {
        return this.mediaChannel;
    }

    public final Integer getSentenceIndex() {
        return this.sentenceIndex;
    }

    public final BigDecimal getStartTime() {
        return this.startTime;
    }

    public final BigDecimal getEndTime() {
        return this.endTime;
    }

    public final String getTranscript() {
        return this.transcript;
    }

    public final String getSid() {
        return this.sid;
    }

    public final BigDecimal getConfidence() {
        return this.confidence;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Sentence other = (Sentence) o;

        return (
            Objects.equals(mediaChannel, other.mediaChannel) &&
            Objects.equals(sentenceIndex, other.sentenceIndex) &&
            Objects.equals(startTime, other.startTime) &&
            Objects.equals(endTime, other.endTime) &&
            Objects.equals(transcript, other.transcript) &&
            Objects.equals(sid, other.sid) &&
            Objects.equals(confidence, other.confidence)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            mediaChannel,
            sentenceIndex,
            startTime,
            endTime,
            transcript,
            sid,
            confidence
        );
    }
}
