/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Media
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.media.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class MediaProcessor extends Resource {

    private static final long serialVersionUID = 112801700822600L;

    public static MediaProcessorCreator creator(
        final String extension,
        final String extensionContext
    ) {
        return new MediaProcessorCreator(extension, extensionContext);
    }

    public static MediaProcessorFetcher fetcher(final String pathSid) {
        return new MediaProcessorFetcher(pathSid);
    }

    public static MediaProcessorReader reader() {
        return new MediaProcessorReader();
    }

    public static MediaProcessorUpdater updater(
        final String pathSid,
        final MediaProcessor.UpdateStatus status
    ) {
        return new MediaProcessorUpdater(pathSid, status);
    }

    /**
     * Converts a JSON String into a MediaProcessor object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return MediaProcessor object represented by the provided JSON
     */
    public static MediaProcessor fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, MediaProcessor.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a MediaProcessor object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return MediaProcessor object represented by the provided JSON
     */
    public static MediaProcessor fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, MediaProcessor.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public enum Order {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private Order(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static Order forValue(final String value) {
            return Promoter.enumFromString(value, Order.values());
        }
    }

    public enum Status {
        FAILED("failed"),
        STARTED("started"),
        ENDED("ended");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    public enum UpdateStatus {
        ENDED("ended");

        private final String value;

        private UpdateStatus(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static UpdateStatus forValue(final String value) {
            return Promoter.enumFromString(value, UpdateStatus.values());
        }
    }

    private final String accountSid;
    private final String sid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final String extension;
    private final String extensionContext;
    private final MediaProcessor.Status status;
    private final URI url;
    private final String endedReason;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final Integer maxDuration;

    @JsonCreator
    private MediaProcessor(
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("sid") final String sid,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("extension") final String extension,
        @JsonProperty("extension_context") final String extensionContext,
        @JsonProperty("status") final MediaProcessor.Status status,
        @JsonProperty("url") final URI url,
        @JsonProperty("ended_reason") final String endedReason,
        @JsonProperty("status_callback") final URI statusCallback,
        @JsonProperty(
            "status_callback_method"
        ) final HttpMethod statusCallbackMethod,
        @JsonProperty("max_duration") final Integer maxDuration
    ) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.extension = extension;
        this.extensionContext = extensionContext;
        this.status = status;
        this.url = url;
        this.endedReason = endedReason;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.maxDuration = maxDuration;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getExtension() {
        return this.extension;
    }

    public final String getExtensionContext() {
        return this.extensionContext;
    }

    public final MediaProcessor.Status getStatus() {
        return this.status;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getEndedReason() {
        return this.endedReason;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final Integer getMaxDuration() {
        return this.maxDuration;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        MediaProcessor other = (MediaProcessor) o;

        return (
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(sid, other.sid) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(extension, other.extension) &&
            Objects.equals(extensionContext, other.extensionContext) &&
            Objects.equals(status, other.status) &&
            Objects.equals(url, other.url) &&
            Objects.equals(endedReason, other.endedReason) &&
            Objects.equals(statusCallback, other.statusCallback) &&
            Objects.equals(statusCallbackMethod, other.statusCallbackMethod) &&
            Objects.equals(maxDuration, other.maxDuration)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            accountSid,
            sid,
            dateCreated,
            dateUpdated,
            extension,
            extensionContext,
            status,
            url,
            endedReason,
            statusCallback,
            statusCallbackMethod,
            maxDuration
        );
    }
}
