/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class DomainConfig extends Resource {

    private static final long serialVersionUID = 278004827100918L;

    public static DomainConfigFetcher fetcher(final String pathDomainSid) {
        return new DomainConfigFetcher(pathDomainSid);
    }

    public static DomainConfigUpdater updater(final String pathDomainSid) {
        return new DomainConfigUpdater(pathDomainSid);
    }

    /**
     * Converts a JSON String into a DomainConfig object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return DomainConfig object represented by the provided JSON
     */
    public static DomainConfig fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, DomainConfig.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a DomainConfig object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return DomainConfig object represented by the provided JSON
     */
    public static DomainConfig fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, DomainConfig.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String domainSid;
    private final String configSid;
    private final URI fallbackUrl;
    private final URI callbackUrl;
    private final Boolean continueOnFailure;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Boolean disableHttps;

    @JsonCreator
    private DomainConfig(
        @JsonProperty("domain_sid") final String domainSid,
        @JsonProperty("config_sid") final String configSid,
        @JsonProperty("fallback_url") final URI fallbackUrl,
        @JsonProperty("callback_url") final URI callbackUrl,
        @JsonProperty("continue_on_failure") final Boolean continueOnFailure,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("url") final URI url,
        @JsonProperty("disable_https") final Boolean disableHttps
    ) {
        this.domainSid = domainSid;
        this.configSid = configSid;
        this.fallbackUrl = fallbackUrl;
        this.callbackUrl = callbackUrl;
        this.continueOnFailure = continueOnFailure;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.disableHttps = disableHttps;
    }

    public final String getDomainSid() {
        return this.domainSid;
    }

    public final String getConfigSid() {
        return this.configSid;
    }

    public final URI getFallbackUrl() {
        return this.fallbackUrl;
    }

    public final URI getCallbackUrl() {
        return this.callbackUrl;
    }

    public final Boolean getContinueOnFailure() {
        return this.continueOnFailure;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Boolean getDisableHttps() {
        return this.disableHttps;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DomainConfig other = (DomainConfig) o;

        return (
            Objects.equals(domainSid, other.domainSid) &&
            Objects.equals(configSid, other.configSid) &&
            Objects.equals(fallbackUrl, other.fallbackUrl) &&
            Objects.equals(callbackUrl, other.callbackUrl) &&
            Objects.equals(continueOnFailure, other.continueOnFailure) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(url, other.url) &&
            Objects.equals(disableHttps, other.disableHttps)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            domainSid,
            configSid,
            fallbackUrl,
            callbackUrl,
            continueOnFailure,
            dateCreated,
            dateUpdated,
            url,
            disableHttps
        );
    }
}
