/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.messaging.v1.brandregistration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class BrandRegistrationOtp extends Resource {

    private static final long serialVersionUID = 131615733171627L;

    public static BrandRegistrationOtpCreator creator(
        final String pathBrandRegistrationSid
    ) {
        return new BrandRegistrationOtpCreator(pathBrandRegistrationSid);
    }

    /**
     * Converts a JSON String into a BrandRegistrationOtp object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return BrandRegistrationOtp object represented by the provided JSON
     */
    public static BrandRegistrationOtp fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, BrandRegistrationOtp.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a BrandRegistrationOtp object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return BrandRegistrationOtp object represented by the provided JSON
     */
    public static BrandRegistrationOtp fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, BrandRegistrationOtp.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String brandRegistrationSid;

    @JsonCreator
    private BrandRegistrationOtp(
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty(
            "brand_registration_sid"
        ) final String brandRegistrationSid
    ) {
        this.accountSid = accountSid;
        this.brandRegistrationSid = brandRegistrationSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getBrandRegistrationSid() {
        return this.brandRegistrationSid;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        BrandRegistrationOtp other = (BrandRegistrationOtp) o;

        return (
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(brandRegistrationSid, other.brandRegistrationSid)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountSid, brandRegistrationSid);
    }
}
