/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.messaging.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class ChannelSender extends Resource {

    private static final long serialVersionUID = 32697428616380L;

    public static ChannelSenderFetcher fetcher(
        final String pathMessagingServiceSid,
        final String pathSid
    ) {
        return new ChannelSenderFetcher(pathMessagingServiceSid, pathSid);
    }

    public static ChannelSenderReader reader(
        final String pathMessagingServiceSid
    ) {
        return new ChannelSenderReader(pathMessagingServiceSid);
    }

    /**
     * Converts a JSON String into a ChannelSender object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return ChannelSender object represented by the provided JSON
     */
    public static ChannelSender fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ChannelSender.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a ChannelSender object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return ChannelSender object represented by the provided JSON
     */
    public static ChannelSender fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ChannelSender.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String messagingServiceSid;
    private final String sid;
    private final String sender;
    private final String senderType;
    private final String countryCode;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private ChannelSender(
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("messaging_service_sid") final String messagingServiceSid,
        @JsonProperty("sid") final String sid,
        @JsonProperty("sender") final String sender,
        @JsonProperty("sender_type") final String senderType,
        @JsonProperty("country_code") final String countryCode,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("url") final URI url
    ) {
        this.accountSid = accountSid;
        this.messagingServiceSid = messagingServiceSid;
        this.sid = sid;
        this.sender = sender;
        this.senderType = senderType;
        this.countryCode = countryCode;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getSender() {
        return this.sender;
    }

    public final String getSenderType() {
        return this.senderType;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ChannelSender other = (ChannelSender) o;

        return (
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(messagingServiceSid, other.messagingServiceSid) &&
            Objects.equals(sid, other.sid) &&
            Objects.equals(sender, other.sender) &&
            Objects.equals(senderType, other.senderType) &&
            Objects.equals(countryCode, other.countryCode) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            accountSid,
            messagingServiceSid,
            sid,
            sender,
            senderType,
            countryCode,
            dateCreated,
            dateUpdated,
            url
        );
    }
}
