/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.messaging.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class UsAppToPersonUsecase extends Resource {

    private static final long serialVersionUID = 181251380697241L;

    public static UsAppToPersonUsecaseFetcher fetcher(
        final String pathMessagingServiceSid
    ) {
        return new UsAppToPersonUsecaseFetcher(pathMessagingServiceSid);
    }

    /**
     * Converts a JSON String into a UsAppToPersonUsecase object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return UsAppToPersonUsecase object represented by the provided JSON
     */
    public static UsAppToPersonUsecase fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, UsAppToPersonUsecase.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a UsAppToPersonUsecase object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return UsAppToPersonUsecase object represented by the provided JSON
     */
    public static UsAppToPersonUsecase fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, UsAppToPersonUsecase.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final List<Map<String, Object>> usAppToPersonUsecases;

    @JsonCreator
    private UsAppToPersonUsecase(
        @JsonProperty("us_app_to_person_usecases") final List<
            Map<String, Object>
        > usAppToPersonUsecases
    ) {
        this.usAppToPersonUsecases = usAppToPersonUsecases;
    }

    public final List<Map<String, Object>> getUsAppToPersonUsecases() {
        return this.usAppToPersonUsecases;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UsAppToPersonUsecase other = (UsAppToPersonUsecase) o;

        return Objects.equals(
            usAppToPersonUsecases,
            other.usAppToPersonUsecases
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(usAppToPersonUsecases);
    }
}
