/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Microvisor
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.microvisor.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class AccountConfig extends Resource {

    private static final long serialVersionUID = 212393375904180L;

    public static AccountConfigCreator creator(
        final String key,
        final String value
    ) {
        return new AccountConfigCreator(key, value);
    }

    public static AccountConfigDeleter deleter(final String pathKey) {
        return new AccountConfigDeleter(pathKey);
    }

    public static AccountConfigFetcher fetcher(final String pathKey) {
        return new AccountConfigFetcher(pathKey);
    }

    public static AccountConfigReader reader() {
        return new AccountConfigReader();
    }

    public static AccountConfigUpdater updater(
        final String pathKey,
        final String value
    ) {
        return new AccountConfigUpdater(pathKey, value);
    }

    /**
     * Converts a JSON String into a AccountConfig object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return AccountConfig object represented by the provided JSON
     */
    public static AccountConfig fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, AccountConfig.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a AccountConfig object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return AccountConfig object represented by the provided JSON
     */
    public static AccountConfig fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, AccountConfig.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String key;
    private final ZonedDateTime dateUpdated;
    private final String value;
    private final URI url;

    @JsonCreator
    private AccountConfig(
        @JsonProperty("key") final String key,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("value") final String value,
        @JsonProperty("url") final URI url
    ) {
        this.key = key;
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.value = value;
        this.url = url;
    }

    public final String getKey() {
        return this.key;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getValue() {
        return this.value;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        AccountConfig other = (AccountConfig) o;

        return (
            Objects.equals(key, other.key) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(value, other.value) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, dateUpdated, value, url);
    }
}
