/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Microvisor
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.microvisor.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class DeviceUpdater extends Updater<Device> {

    private String pathSid;
    private String uniqueName;
    private String targetApp;
    private Boolean loggingEnabled;
    private Boolean restartApp;

    public DeviceUpdater(final String pathSid) {
        this.pathSid = pathSid;
    }

    public DeviceUpdater setUniqueName(final String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public DeviceUpdater setTargetApp(final String targetApp) {
        this.targetApp = targetApp;
        return this;
    }

    public DeviceUpdater setLoggingEnabled(final Boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        return this;
    }

    public DeviceUpdater setRestartApp(final Boolean restartApp) {
        this.restartApp = restartApp;
        return this;
    }

    @Override
    public Device update(final TwilioRestClient client) {
        String path = "/v1/Devices/{Sid}";

        path = path.replace("{" + "Sid" + "}", this.pathSid.toString());

        Request request = new Request(
            HttpMethod.POST,
            Domains.MICROVISOR.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "Device update failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return Device.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(final Request request) {
        if (uniqueName != null) {
            request.addPostParam("UniqueName", uniqueName);
        }
        if (targetApp != null) {
            request.addPostParam("TargetApp", targetApp);
        }
        if (loggingEnabled != null) {
            request.addPostParam("LoggingEnabled", loggingEnabled.toString());
        }
        if (restartApp != null) {
            request.addPostParam("RestartApp", restartApp.toString());
        }
    }
}
