/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class BulkEligibility extends Resource {

    private static final long serialVersionUID = 38354491175250L;

    public static BulkEligibilityFetcher fetcher(final String pathRequestId) {
        return new BulkEligibilityFetcher(pathRequestId);
    }

    /**
     * Converts a JSON String into a BulkEligibility object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return BulkEligibility object represented by the provided JSON
     */
    public static BulkEligibility fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, BulkEligibility.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a BulkEligibility object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return BulkEligibility object represented by the provided JSON
     */
    public static BulkEligibility fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, BulkEligibility.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String requestId;
    private final URI url;
    private final List<Map<String, Object>> results;
    private final String friendlyName;
    private final String status;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateCompleted;

    @JsonCreator
    private BulkEligibility(
        @JsonProperty("request_id") final String requestId,
        @JsonProperty("url") final URI url,
        @JsonProperty("results") final List<Map<String, Object>> results,
        @JsonProperty("friendly_name") final String friendlyName,
        @JsonProperty("status") final String status,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_completed") final String dateCompleted
    ) {
        this.requestId = requestId;
        this.url = url;
        this.results = results;
        this.friendlyName = friendlyName;
        this.status = status;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateCompleted =
            DateConverter.iso8601DateTimeFromString(dateCompleted);
    }

    public final String getRequestId() {
        return this.requestId;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final List<Map<String, Object>> getResults() {
        return this.results;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getStatus() {
        return this.status;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateCompleted() {
        return this.dateCompleted;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        BulkEligibility other = (BulkEligibility) o;

        return (
            Objects.equals(requestId, other.requestId) &&
            Objects.equals(url, other.url) &&
            Objects.equals(results, other.results) &&
            Objects.equals(friendlyName, other.friendlyName) &&
            Objects.equals(status, other.status) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateCompleted, other.dateCompleted)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            requestId,
            url,
            results,
            friendlyName,
            status,
            dateCreated,
            dateCompleted
        );
    }
}
