/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.numbers.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class PortingPortability extends Resource {

    private static final long serialVersionUID = 225988214270980L;

    public static PortingPortabilityFetcher fetcher(
        final com.twilio.type.PhoneNumber pathPhoneNumber
    ) {
        return new PortingPortabilityFetcher(pathPhoneNumber);
    }

    /**
     * Converts a JSON String into a PortingPortability object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return PortingPortability object represented by the provided JSON
     */
    public static PortingPortability fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, PortingPortability.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a PortingPortability object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return PortingPortability object represented by the provided JSON
     */
    public static PortingPortability fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, PortingPortability.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public enum NumberType {
        LOCAL("LOCAL"),
        UNKNOWN("UNKNOWN"),
        MOBILE("MOBILE"),
        TOLL_FREE("TOLL-FREE");

        private final String value;

        private NumberType(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static NumberType forValue(final String value) {
            return Promoter.enumFromString(value, NumberType.values());
        }
    }

    private final com.twilio.type.PhoneNumber phoneNumber;
    private final String accountSid;
    private final Boolean portable;
    private final Boolean pinAndAccountNumberRequired;
    private final String notPortableReason;
    private final Integer notPortableReasonCode;
    private final PortingPortability.NumberType numberType;
    private final String country;
    private final String messagingCarrier;
    private final String voiceCarrier;
    private final URI url;

    @JsonCreator
    private PortingPortability(
        @JsonProperty(
            "phone_number"
        ) final com.twilio.type.PhoneNumber phoneNumber,
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("portable") final Boolean portable,
        @JsonProperty(
            "pin_and_account_number_required"
        ) final Boolean pinAndAccountNumberRequired,
        @JsonProperty("not_portable_reason") final String notPortableReason,
        @JsonProperty(
            "not_portable_reason_code"
        ) final Integer notPortableReasonCode,
        @JsonProperty(
            "number_type"
        ) final PortingPortability.NumberType numberType,
        @JsonProperty("country") final String country,
        @JsonProperty("messaging_carrier") final String messagingCarrier,
        @JsonProperty("voice_carrier") final String voiceCarrier,
        @JsonProperty("url") final URI url
    ) {
        this.phoneNumber = phoneNumber;
        this.accountSid = accountSid;
        this.portable = portable;
        this.pinAndAccountNumberRequired = pinAndAccountNumberRequired;
        this.notPortableReason = notPortableReason;
        this.notPortableReasonCode = notPortableReasonCode;
        this.numberType = numberType;
        this.country = country;
        this.messagingCarrier = messagingCarrier;
        this.voiceCarrier = voiceCarrier;
        this.url = url;
    }

    public final com.twilio.type.PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Boolean getPortable() {
        return this.portable;
    }

    public final Boolean getPinAndAccountNumberRequired() {
        return this.pinAndAccountNumberRequired;
    }

    public final String getNotPortableReason() {
        return this.notPortableReason;
    }

    public final Integer getNotPortableReasonCode() {
        return this.notPortableReasonCode;
    }

    public final PortingPortability.NumberType getNumberType() {
        return this.numberType;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getMessagingCarrier() {
        return this.messagingCarrier;
    }

    public final String getVoiceCarrier() {
        return this.voiceCarrier;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        PortingPortability other = (PortingPortability) o;

        return (
            Objects.equals(phoneNumber, other.phoneNumber) &&
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(portable, other.portable) &&
            Objects.equals(
                pinAndAccountNumberRequired,
                other.pinAndAccountNumberRequired
            ) &&
            Objects.equals(notPortableReason, other.notPortableReason) &&
            Objects.equals(
                notPortableReasonCode,
                other.notPortableReasonCode
            ) &&
            Objects.equals(numberType, other.numberType) &&
            Objects.equals(country, other.country) &&
            Objects.equals(messagingCarrier, other.messagingCarrier) &&
            Objects.equals(voiceCarrier, other.voiceCarrier) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            phoneNumber,
            accountSid,
            portable,
            pinAndAccountNumberRequired,
            notPortableReason,
            notPortableReasonCode,
            numberType,
            country,
            messagingCarrier,
            voiceCarrier,
            url
        );
    }
}
