/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Regulation extends Resource {

    private static final long serialVersionUID = 10727481359923L;

    public static RegulationFetcher fetcher(final String pathSid) {
        return new RegulationFetcher(pathSid);
    }

    public static RegulationReader reader() {
        return new RegulationReader();
    }

    /**
     * Converts a JSON String into a Regulation object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Regulation object represented by the provided JSON
     */
    public static Regulation fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Regulation.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Regulation object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Regulation object represented by the provided JSON
     */
    public static Regulation fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Regulation.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public enum EndUserType {
        INDIVIDUAL("individual"),
        BUSINESS("business");

        private final String value;

        private EndUserType(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static EndUserType forValue(final String value) {
            return Promoter.enumFromString(value, EndUserType.values());
        }
    }

    private final String sid;
    private final String friendlyName;
    private final String isoCountry;
    private final String numberType;
    private final Regulation.EndUserType endUserType;
    private final Map<String, Object> requirements;
    private final URI url;

    @JsonCreator
    private Regulation(
        @JsonProperty("sid") final String sid,
        @JsonProperty("friendly_name") final String friendlyName,
        @JsonProperty("iso_country") final String isoCountry,
        @JsonProperty("number_type") final String numberType,
        @JsonProperty("end_user_type") final Regulation.EndUserType endUserType,
        @JsonProperty("requirements") final Map<String, Object> requirements,
        @JsonProperty("url") final URI url
    ) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.isoCountry = isoCountry;
        this.numberType = numberType;
        this.endUserType = endUserType;
        this.requirements = requirements;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final String getNumberType() {
        return this.numberType;
    }

    public final Regulation.EndUserType getEndUserType() {
        return this.endUserType;
    }

    public final Map<String, Object> getRequirements() {
        return this.requirements;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Regulation other = (Regulation) o;

        return (
            Objects.equals(sid, other.sid) &&
            Objects.equals(friendlyName, other.friendlyName) &&
            Objects.equals(isoCountry, other.isoCountry) &&
            Objects.equals(numberType, other.numberType) &&
            Objects.equals(endUserType, other.endUserType) &&
            Objects.equals(requirements, other.requirements) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            sid,
            friendlyName,
            isoCountry,
            numberType,
            endUserType,
            requirements,
            url
        );
    }
}
