/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.numbers.v2.regulatorycompliance.bundle;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Evaluation extends Resource {

    private static final long serialVersionUID = 28761307513576L;

    public static EvaluationCreator creator(final String pathBundleSid) {
        return new EvaluationCreator(pathBundleSid);
    }

    public static EvaluationFetcher fetcher(
        final String pathBundleSid,
        final String pathSid
    ) {
        return new EvaluationFetcher(pathBundleSid, pathSid);
    }

    public static EvaluationReader reader(final String pathBundleSid) {
        return new EvaluationReader(pathBundleSid);
    }

    /**
     * Converts a JSON String into a Evaluation object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Evaluation object represented by the provided JSON
     */
    public static Evaluation fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Evaluation.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Evaluation object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Evaluation object represented by the provided JSON
     */
    public static Evaluation fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Evaluation.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public enum Status {
        COMPLIANT("compliant"),
        NONCOMPLIANT("noncompliant");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    private final String sid;
    private final String accountSid;
    private final String regulationSid;
    private final String bundleSid;
    private final Evaluation.Status status;
    private final List<Map<String, Object>> results;
    private final ZonedDateTime dateCreated;
    private final URI url;

    @JsonCreator
    private Evaluation(
        @JsonProperty("sid") final String sid,
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("regulation_sid") final String regulationSid,
        @JsonProperty("bundle_sid") final String bundleSid,
        @JsonProperty("status") final Evaluation.Status status,
        @JsonProperty("results") final List<Map<String, Object>> results,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("url") final URI url
    ) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.regulationSid = regulationSid;
        this.bundleSid = bundleSid;
        this.status = status;
        this.results = results;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getRegulationSid() {
        return this.regulationSid;
    }

    public final String getBundleSid() {
        return this.bundleSid;
    }

    public final Evaluation.Status getStatus() {
        return this.status;
    }

    public final List<Map<String, Object>> getResults() {
        return this.results;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Evaluation other = (Evaluation) o;

        return (
            Objects.equals(sid, other.sid) &&
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(regulationSid, other.regulationSid) &&
            Objects.equals(bundleSid, other.bundleSid) &&
            Objects.equals(status, other.status) &&
            Objects.equals(results, other.results) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            sid,
            accountSid,
            regulationSid,
            bundleSid,
            status,
            results,
            dateCreated,
            url
        );
    }
}
