/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Oauth
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.oauth.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class UserInfo extends Resource {

    private static final long serialVersionUID = 74270157944596L;

    public static UserInfoFetcher fetcher() {
        return new UserInfoFetcher();
    }

    /**
     * Converts a JSON String into a UserInfo object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return UserInfo object represented by the provided JSON
     */
    public static UserInfo fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, UserInfo.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a UserInfo object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return UserInfo object represented by the provided JSON
     */
    public static UserInfo fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, UserInfo.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String userSid;
    private final String firstName;
    private final String lastName;
    private final String friendlyName;
    private final String email;
    private final URI url;

    @JsonCreator
    private UserInfo(
        @JsonProperty("user_sid") final String userSid,
        @JsonProperty("first_name") final String firstName,
        @JsonProperty("last_name") final String lastName,
        @JsonProperty("friendly_name") final String friendlyName,
        @JsonProperty("email") final String email,
        @JsonProperty("url") final URI url
    ) {
        this.userSid = userSid;
        this.firstName = firstName;
        this.lastName = lastName;
        this.friendlyName = friendlyName;
        this.email = email;
        this.url = url;
    }

    public final String getUserSid() {
        return this.userSid;
    }

    public final String getFirstName() {
        return this.firstName;
    }

    public final String getLastName() {
        return this.lastName;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getEmail() {
        return this.email;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UserInfo other = (UserInfo) o;

        return (
            Objects.equals(userSid, other.userSid) &&
            Objects.equals(firstName, other.firstName) &&
            Objects.equals(lastName, other.lastName) &&
            Objects.equals(friendlyName, other.friendlyName) &&
            Objects.equals(email, other.email) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            userSid,
            firstName,
            lastName,
            friendlyName,
            email,
            url
        );
    }
}
