/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Preview
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.preview.deployedDevices.fleet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Certificate extends Resource {

    private static final long serialVersionUID = 26542571339730L;

    public static CertificateCreator creator(
        final String pathFleetSid,
        final String certificateData
    ) {
        return new CertificateCreator(pathFleetSid, certificateData);
    }

    public static CertificateDeleter deleter(
        final String pathFleetSid,
        final String pathSid
    ) {
        return new CertificateDeleter(pathFleetSid, pathSid);
    }

    public static CertificateFetcher fetcher(
        final String pathFleetSid,
        final String pathSid
    ) {
        return new CertificateFetcher(pathFleetSid, pathSid);
    }

    public static CertificateReader reader(final String pathFleetSid) {
        return new CertificateReader(pathFleetSid);
    }

    public static CertificateUpdater updater(
        final String pathFleetSid,
        final String pathSid
    ) {
        return new CertificateUpdater(pathFleetSid, pathSid);
    }

    /**
     * Converts a JSON String into a Certificate object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Certificate object represented by the provided JSON
     */
    public static Certificate fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Certificate.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Certificate object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Certificate object represented by the provided JSON
     */
    public static Certificate fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Certificate.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final URI url;
    private final String friendlyName;
    private final String fleetSid;
    private final String accountSid;
    private final String deviceSid;
    private final String thumbprint;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    @JsonCreator
    private Certificate(
        @JsonProperty("sid") final String sid,
        @JsonProperty("url") final URI url,
        @JsonProperty("friendly_name") final String friendlyName,
        @JsonProperty("fleet_sid") final String fleetSid,
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("device_sid") final String deviceSid,
        @JsonProperty("thumbprint") final String thumbprint,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated
    ) {
        this.sid = sid;
        this.url = url;
        this.friendlyName = friendlyName;
        this.fleetSid = fleetSid;
        this.accountSid = accountSid;
        this.deviceSid = deviceSid;
        this.thumbprint = thumbprint;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getFleetSid() {
        return this.fleetSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getDeviceSid() {
        return this.deviceSid;
    }

    public final String getThumbprint() {
        return this.thumbprint;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Certificate other = (Certificate) o;

        return (
            Objects.equals(sid, other.sid) &&
            Objects.equals(url, other.url) &&
            Objects.equals(friendlyName, other.friendlyName) &&
            Objects.equals(fleetSid, other.fleetSid) &&
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(deviceSid, other.deviceSid) &&
            Objects.equals(thumbprint, other.thumbprint) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            sid,
            url,
            friendlyName,
            fleetSid,
            accountSid,
            deviceSid,
            thumbprint,
            dateCreated,
            dateUpdated
        );
    }
}
