/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Preview
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.preview.understand;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Converter;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import java.net.URI;
import java.net.URI;
import java.util.Map;
import java.util.Map;

public class AssistantCreator extends Creator<Assistant> {

    private String friendlyName;
    private Boolean logQueries;
    private String uniqueName;
    private URI callbackUrl;
    private String callbackEvents;
    private Map<String, Object> fallbackActions;
    private Map<String, Object> initiationActions;
    private Map<String, Object> styleSheet;

    public AssistantCreator() {}

    public AssistantCreator setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AssistantCreator setLogQueries(final Boolean logQueries) {
        this.logQueries = logQueries;
        return this;
    }

    public AssistantCreator setUniqueName(final String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public AssistantCreator setCallbackUrl(final URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public AssistantCreator setCallbackUrl(final String callbackUrl) {
        return setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public AssistantCreator setCallbackEvents(final String callbackEvents) {
        this.callbackEvents = callbackEvents;
        return this;
    }

    public AssistantCreator setFallbackActions(
        final Map<String, Object> fallbackActions
    ) {
        this.fallbackActions = fallbackActions;
        return this;
    }

    public AssistantCreator setInitiationActions(
        final Map<String, Object> initiationActions
    ) {
        this.initiationActions = initiationActions;
        return this;
    }

    public AssistantCreator setStyleSheet(
        final Map<String, Object> styleSheet
    ) {
        this.styleSheet = styleSheet;
        return this;
    }

    @Override
    public Assistant create(final TwilioRestClient client) {
        String path = "/understand/Assistants";

        Request request = new Request(
            HttpMethod.POST,
            Domains.PREVIEW.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "Assistant creation failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return Assistant.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }

    private void addPostParams(final Request request) {
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }
        if (logQueries != null) {
            request.addPostParam("LogQueries", logQueries.toString());
        }
        if (uniqueName != null) {
            request.addPostParam("UniqueName", uniqueName);
        }
        if (callbackUrl != null) {
            request.addPostParam("CallbackUrl", callbackUrl.toString());
        }
        if (callbackEvents != null) {
            request.addPostParam("CallbackEvents", callbackEvents);
        }
        if (fallbackActions != null) {
            request.addPostParam(
                "FallbackActions",
                Converter.mapToJson(fallbackActions)
            );
        }
        if (initiationActions != null) {
            request.addPostParam(
                "InitiationActions",
                Converter.mapToJson(initiationActions)
            );
        }
        if (styleSheet != null) {
            request.addPostParam("StyleSheet", Converter.mapToJson(styleSheet));
        }
    }
}
