/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Pricing
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.pricing.v1.voice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.type.InboundCallPrice;
import com.twilio.type.OutboundCallPrice;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Currency;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Number extends Resource {

    private static final long serialVersionUID = 23882142179085L;

    public static NumberFetcher fetcher(
        final com.twilio.type.PhoneNumber pathNumber
    ) {
        return new NumberFetcher(pathNumber);
    }

    /**
     * Converts a JSON String into a Number object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Number object represented by the provided JSON
     */
    public static Number fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Number.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Number object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Number object represented by the provided JSON
     */
    public static Number fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Number.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final com.twilio.type.PhoneNumber number;
    private final String country;
    private final String isoCountry;
    private final OutboundCallPrice outboundCallPrice;
    private final InboundCallPrice inboundCallPrice;
    private final Currency priceUnit;
    private final URI url;

    @JsonCreator
    private Number(
        @JsonProperty("number") final com.twilio.type.PhoneNumber number,
        @JsonProperty("country") final String country,
        @JsonProperty("iso_country") final String isoCountry,
        @JsonProperty(
            "outbound_call_price"
        ) final OutboundCallPrice outboundCallPrice,
        @JsonProperty(
            "inbound_call_price"
        ) final InboundCallPrice inboundCallPrice,
        @JsonProperty("price_unit") @JsonDeserialize(
            using = com.twilio.converter.CurrencyDeserializer.class
        ) final Currency priceUnit,
        @JsonProperty("url") final URI url
    ) {
        this.number = number;
        this.country = country;
        this.isoCountry = isoCountry;
        this.outboundCallPrice = outboundCallPrice;
        this.inboundCallPrice = inboundCallPrice;
        this.priceUnit = priceUnit;
        this.url = url;
    }

    public final com.twilio.type.PhoneNumber getNumber() {
        return this.number;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final OutboundCallPrice getOutboundCallPrice() {
        return this.outboundCallPrice;
    }

    public final InboundCallPrice getInboundCallPrice() {
        return this.inboundCallPrice;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Number other = (Number) o;

        return (
            Objects.equals(number, other.number) &&
            Objects.equals(country, other.country) &&
            Objects.equals(isoCountry, other.isoCountry) &&
            Objects.equals(outboundCallPrice, other.outboundCallPrice) &&
            Objects.equals(inboundCallPrice, other.inboundCallPrice) &&
            Objects.equals(priceUnit, other.priceUnit) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            number,
            country,
            isoCountry,
            outboundCallPrice,
            inboundCallPrice,
            priceUnit,
            url
        );
    }
}
