/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Proxy
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.proxy.v1.service.session;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class ParticipantCreator extends Creator<Participant> {

    private String pathServiceSid;
    private String pathSessionSid;
    private String identifier;
    private String friendlyName;
    private String proxyIdentifier;
    private String proxyIdentifierSid;

    public ParticipantCreator(
        final String pathServiceSid,
        final String pathSessionSid,
        final String identifier
    ) {
        this.pathServiceSid = pathServiceSid;
        this.pathSessionSid = pathSessionSid;
        this.identifier = identifier;
    }

    public ParticipantCreator setIdentifier(final String identifier) {
        this.identifier = identifier;
        return this;
    }

    public ParticipantCreator setFriendlyName(final String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ParticipantCreator setProxyIdentifier(final String proxyIdentifier) {
        this.proxyIdentifier = proxyIdentifier;
        return this;
    }

    public ParticipantCreator setProxyIdentifierSid(
        final String proxyIdentifierSid
    ) {
        this.proxyIdentifierSid = proxyIdentifierSid;
        return this;
    }

    @Override
    public Participant create(final TwilioRestClient client) {
        String path =
            "/v1/Services/{ServiceSid}/Sessions/{SessionSid}/Participants";

        path =
            path.replace(
                "{" + "ServiceSid" + "}",
                this.pathServiceSid.toString()
            );
        path =
            path.replace(
                "{" + "SessionSid" + "}",
                this.pathSessionSid.toString()
            );
        path =
            path.replace("{" + "Identifier" + "}", this.identifier.toString());

        Request request = new Request(
            HttpMethod.POST,
            Domains.PROXY.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "Participant creation failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return Participant.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }

    private void addPostParams(final Request request) {
        if (identifier != null) {
            request.addPostParam("Identifier", identifier);
        }
        if (friendlyName != null) {
            request.addPostParam("FriendlyName", friendlyName);
        }
        if (proxyIdentifier != null) {
            request.addPostParam("ProxyIdentifier", proxyIdentifier);
        }
        if (proxyIdentifierSid != null) {
            request.addPostParam("ProxyIdentifierSid", proxyIdentifierSid);
        }
    }
}
