/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Serverless
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.serverless.v1.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import java.util.List;
import java.util.List;

public class BuildCreator extends Creator<Build> {

    private String pathServiceSid;
    private List<String> assetVersions;
    private List<String> functionVersions;
    private String dependencies;
    private String runtime;

    public BuildCreator(final String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public BuildCreator setAssetVersions(final List<String> assetVersions) {
        this.assetVersions = assetVersions;
        return this;
    }

    public BuildCreator setAssetVersions(final String assetVersions) {
        return setAssetVersions(Promoter.listOfOne(assetVersions));
    }

    public BuildCreator setFunctionVersions(
        final List<String> functionVersions
    ) {
        this.functionVersions = functionVersions;
        return this;
    }

    public BuildCreator setFunctionVersions(final String functionVersions) {
        return setFunctionVersions(Promoter.listOfOne(functionVersions));
    }

    public BuildCreator setDependencies(final String dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public BuildCreator setRuntime(final String runtime) {
        this.runtime = runtime;
        return this;
    }

    @Override
    public Build create(final TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Builds";

        path =
            path.replace(
                "{" + "ServiceSid" + "}",
                this.pathServiceSid.toString()
            );

        Request request = new Request(
            HttpMethod.POST,
            Domains.SERVERLESS.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "Build creation failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return Build.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(final Request request) {
        if (assetVersions != null) {
            for (String prop : assetVersions) {
                request.addPostParam("AssetVersions", prop);
            }
        }
        if (functionVersions != null) {
            for (String prop : functionVersions) {
                request.addPostParam("FunctionVersions", prop);
            }
        }
        if (dependencies != null) {
            request.addPostParam("Dependencies", dependencies);
        }
        if (runtime != null) {
            request.addPostParam("Runtime", runtime);
        }
    }
}
