/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Studio
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.studio.v2.flow;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import java.util.List;

public class FlowTestUserUpdater extends Updater<FlowTestUser> {

    private String pathSid;
    private List<String> testUsers;

    public FlowTestUserUpdater(
        final String pathSid,
        final List<String> testUsers
    ) {
        this.pathSid = pathSid;
        this.testUsers = testUsers;
    }

    public FlowTestUserUpdater setTestUsers(final List<String> testUsers) {
        this.testUsers = testUsers;
        return this;
    }

    public FlowTestUserUpdater setTestUsers(final String testUsers) {
        return setTestUsers(Promoter.listOfOne(testUsers));
    }

    @Override
    public FlowTestUser update(final TwilioRestClient client) {
        String path = "/v2/Flows/{Sid}/TestUsers";

        path = path.replace("{" + "Sid" + "}", this.pathSid.toString());
        path = path.replace("{" + "TestUsers" + "}", this.testUsers.toString());

        Request request = new Request(
            HttpMethod.POST,
            Domains.STUDIO.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "FlowTestUser update failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return FlowTestUser.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }

    private void addPostParams(final Request request) {
        if (testUsers != null) {
            for (String prop : testUsers) {
                request.addPostParam("TestUsers", prop);
            }
        }
    }
}
