/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Supersim
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class EsimProfile extends Resource {

    private static final long serialVersionUID = 165735118410901L;

    public static EsimProfileCreator creator() {
        return new EsimProfileCreator();
    }

    public static EsimProfileFetcher fetcher(final String pathSid) {
        return new EsimProfileFetcher(pathSid);
    }

    public static EsimProfileReader reader() {
        return new EsimProfileReader();
    }

    /**
     * Converts a JSON String into a EsimProfile object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return EsimProfile object represented by the provided JSON
     */
    public static EsimProfile fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, EsimProfile.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a EsimProfile object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return EsimProfile object represented by the provided JSON
     */
    public static EsimProfile fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, EsimProfile.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public enum Status {
        NEW("new"),
        RESERVING("reserving"),
        AVAILABLE("available"),
        DOWNLOADED("downloaded"),
        INSTALLED("installed"),
        FAILED("failed");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    private final String sid;
    private final String accountSid;
    private final String iccid;
    private final String simSid;
    private final EsimProfile.Status status;
    private final String eid;
    private final URI smdpPlusAddress;
    private final String matchingId;
    private final String activationCode;
    private final String errorCode;
    private final String errorMessage;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    @JsonCreator
    private EsimProfile(
        @JsonProperty("sid") final String sid,
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("iccid") final String iccid,
        @JsonProperty("sim_sid") final String simSid,
        @JsonProperty("status") final EsimProfile.Status status,
        @JsonProperty("eid") final String eid,
        @JsonProperty("smdp_plus_address") final URI smdpPlusAddress,
        @JsonProperty("matching_id") final String matchingId,
        @JsonProperty("activation_code") final String activationCode,
        @JsonProperty("error_code") final String errorCode,
        @JsonProperty("error_message") final String errorMessage,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("url") final URI url
    ) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.iccid = iccid;
        this.simSid = simSid;
        this.status = status;
        this.eid = eid;
        this.smdpPlusAddress = smdpPlusAddress;
        this.matchingId = matchingId;
        this.activationCode = activationCode;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getIccid() {
        return this.iccid;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final EsimProfile.Status getStatus() {
        return this.status;
    }

    public final String getEid() {
        return this.eid;
    }

    public final URI getSmdpPlusAddress() {
        return this.smdpPlusAddress;
    }

    public final String getMatchingId() {
        return this.matchingId;
    }

    public final String getActivationCode() {
        return this.activationCode;
    }

    public final String getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        EsimProfile other = (EsimProfile) o;

        return (
            Objects.equals(sid, other.sid) &&
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(iccid, other.iccid) &&
            Objects.equals(simSid, other.simSid) &&
            Objects.equals(status, other.status) &&
            Objects.equals(eid, other.eid) &&
            Objects.equals(smdpPlusAddress, other.smdpPlusAddress) &&
            Objects.equals(matchingId, other.matchingId) &&
            Objects.equals(activationCode, other.activationCode) &&
            Objects.equals(errorCode, other.errorCode) &&
            Objects.equals(errorMessage, other.errorMessage) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            sid,
            accountSid,
            iccid,
            simSid,
            status,
            eid,
            smdpPlusAddress,
            matchingId,
            activationCode,
            errorCode,
            errorMessage,
            dateCreated,
            dateUpdated,
            url
        );
    }
}
