/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Taskrouter
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Task extends Resource {

    private static final long serialVersionUID = 251819622477624L;

    public static TaskCreator creator(final String pathWorkspaceSid) {
        return new TaskCreator(pathWorkspaceSid);
    }

    public static TaskDeleter deleter(
        final String pathWorkspaceSid,
        final String pathSid
    ) {
        return new TaskDeleter(pathWorkspaceSid, pathSid);
    }

    public static TaskFetcher fetcher(
        final String pathWorkspaceSid,
        final String pathSid
    ) {
        return new TaskFetcher(pathWorkspaceSid, pathSid);
    }

    public static TaskReader reader(final String pathWorkspaceSid) {
        return new TaskReader(pathWorkspaceSid);
    }

    public static TaskUpdater updater(
        final String pathWorkspaceSid,
        final String pathSid
    ) {
        return new TaskUpdater(pathWorkspaceSid, pathSid);
    }

    /**
     * Converts a JSON String into a Task object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Task object represented by the provided JSON
     */
    public static Task fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Task.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Task object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Task object represented by the provided JSON
     */
    public static Task fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Task.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public enum Status {
        PENDING("pending"),
        RESERVED("reserved"),
        ASSIGNED("assigned"),
        CANCELED("canceled"),
        COMPLETED("completed"),
        WRAPPING("wrapping");

        private final String value;

        private Status(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static Status forValue(final String value) {
            return Promoter.enumFromString(value, Status.values());
        }
    }

    private final String accountSid;
    private final Integer age;
    private final Task.Status assignmentStatus;
    private final String attributes;
    private final String addons;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final ZonedDateTime taskQueueEnteredDate;
    private final Integer priority;
    private final String reason;
    private final String sid;
    private final String taskQueueSid;
    private final String taskQueueFriendlyName;
    private final String taskChannelSid;
    private final String taskChannelUniqueName;
    private final Integer timeout;
    private final String workflowSid;
    private final String workflowFriendlyName;
    private final String workspaceSid;
    private final URI url;
    private final Map<String, String> links;
    private final ZonedDateTime virtualStartTime;

    @JsonCreator
    private Task(
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("age") final Integer age,
        @JsonProperty("assignment_status") final Task.Status assignmentStatus,
        @JsonProperty("attributes") final String attributes,
        @JsonProperty("addons") final String addons,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty(
            "task_queue_entered_date"
        ) final String taskQueueEnteredDate,
        @JsonProperty("priority") final Integer priority,
        @JsonProperty("reason") final String reason,
        @JsonProperty("sid") final String sid,
        @JsonProperty("task_queue_sid") final String taskQueueSid,
        @JsonProperty(
            "task_queue_friendly_name"
        ) final String taskQueueFriendlyName,
        @JsonProperty("task_channel_sid") final String taskChannelSid,
        @JsonProperty(
            "task_channel_unique_name"
        ) final String taskChannelUniqueName,
        @JsonProperty("timeout") final Integer timeout,
        @JsonProperty("workflow_sid") final String workflowSid,
        @JsonProperty(
            "workflow_friendly_name"
        ) final String workflowFriendlyName,
        @JsonProperty("workspace_sid") final String workspaceSid,
        @JsonProperty("url") final URI url,
        @JsonProperty("links") final Map<String, String> links,
        @JsonProperty("virtual_start_time") final String virtualStartTime
    ) {
        this.accountSid = accountSid;
        this.age = age;
        this.assignmentStatus = assignmentStatus;
        this.attributes = attributes;
        this.addons = addons;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.taskQueueEnteredDate =
            DateConverter.iso8601DateTimeFromString(taskQueueEnteredDate);
        this.priority = priority;
        this.reason = reason;
        this.sid = sid;
        this.taskQueueSid = taskQueueSid;
        this.taskQueueFriendlyName = taskQueueFriendlyName;
        this.taskChannelSid = taskChannelSid;
        this.taskChannelUniqueName = taskChannelUniqueName;
        this.timeout = timeout;
        this.workflowSid = workflowSid;
        this.workflowFriendlyName = workflowFriendlyName;
        this.workspaceSid = workspaceSid;
        this.url = url;
        this.links = links;
        this.virtualStartTime =
            DateConverter.iso8601DateTimeFromString(virtualStartTime);
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getAge() {
        return this.age;
    }

    public final Task.Status getAssignmentStatus() {
        return this.assignmentStatus;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final String getAddons() {
        return this.addons;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final ZonedDateTime getTaskQueueEnteredDate() {
        return this.taskQueueEnteredDate;
    }

    public final Integer getPriority() {
        return this.priority;
    }

    public final String getReason() {
        return this.reason;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTaskQueueSid() {
        return this.taskQueueSid;
    }

    public final String getTaskQueueFriendlyName() {
        return this.taskQueueFriendlyName;
    }

    public final String getTaskChannelSid() {
        return this.taskChannelSid;
    }

    public final String getTaskChannelUniqueName() {
        return this.taskChannelUniqueName;
    }

    public final Integer getTimeout() {
        return this.timeout;
    }

    public final String getWorkflowSid() {
        return this.workflowSid;
    }

    public final String getWorkflowFriendlyName() {
        return this.workflowFriendlyName;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final ZonedDateTime getVirtualStartTime() {
        return this.virtualStartTime;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Task other = (Task) o;

        return (
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(age, other.age) &&
            Objects.equals(assignmentStatus, other.assignmentStatus) &&
            Objects.equals(attributes, other.attributes) &&
            Objects.equals(addons, other.addons) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(taskQueueEnteredDate, other.taskQueueEnteredDate) &&
            Objects.equals(priority, other.priority) &&
            Objects.equals(reason, other.reason) &&
            Objects.equals(sid, other.sid) &&
            Objects.equals(taskQueueSid, other.taskQueueSid) &&
            Objects.equals(
                taskQueueFriendlyName,
                other.taskQueueFriendlyName
            ) &&
            Objects.equals(taskChannelSid, other.taskChannelSid) &&
            Objects.equals(
                taskChannelUniqueName,
                other.taskChannelUniqueName
            ) &&
            Objects.equals(timeout, other.timeout) &&
            Objects.equals(workflowSid, other.workflowSid) &&
            Objects.equals(workflowFriendlyName, other.workflowFriendlyName) &&
            Objects.equals(workspaceSid, other.workspaceSid) &&
            Objects.equals(url, other.url) &&
            Objects.equals(links, other.links) &&
            Objects.equals(virtualStartTime, other.virtualStartTime)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            accountSid,
            age,
            assignmentStatus,
            attributes,
            addons,
            dateCreated,
            dateUpdated,
            taskQueueEnteredDate,
            priority,
            reason,
            sid,
            taskQueueSid,
            taskQueueFriendlyName,
            taskChannelSid,
            taskChannelUniqueName,
            timeout,
            workflowSid,
            workflowFriendlyName,
            workspaceSid,
            url,
            links,
            virtualStartTime
        );
    }
}
