/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Taskrouter
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Worker extends Resource {

    private static final long serialVersionUID = 110824061154379L;

    public static WorkerCreator creator(
        final String pathWorkspaceSid,
        final String friendlyName
    ) {
        return new WorkerCreator(pathWorkspaceSid, friendlyName);
    }

    public static WorkerDeleter deleter(
        final String pathWorkspaceSid,
        final String pathSid
    ) {
        return new WorkerDeleter(pathWorkspaceSid, pathSid);
    }

    public static WorkerFetcher fetcher(
        final String pathWorkspaceSid,
        final String pathSid
    ) {
        return new WorkerFetcher(pathWorkspaceSid, pathSid);
    }

    public static WorkerReader reader(final String pathWorkspaceSid) {
        return new WorkerReader(pathWorkspaceSid);
    }

    public static WorkerUpdater updater(
        final String pathWorkspaceSid,
        final String pathSid
    ) {
        return new WorkerUpdater(pathWorkspaceSid, pathSid);
    }

    /**
     * Converts a JSON String into a Worker object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Worker object represented by the provided JSON
     */
    public static Worker fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Worker.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Worker object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Worker object represented by the provided JSON
     */
    public static Worker fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Worker.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String accountSid;
    private final String activityName;
    private final String activitySid;
    private final String attributes;
    private final Boolean available;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateStatusChanged;
    private final ZonedDateTime dateUpdated;
    private final String friendlyName;
    private final String sid;
    private final String workspaceSid;
    private final URI url;
    private final Map<String, String> links;

    @JsonCreator
    private Worker(
        @JsonProperty("account_sid") final String accountSid,
        @JsonProperty("activity_name") final String activityName,
        @JsonProperty("activity_sid") final String activitySid,
        @JsonProperty("attributes") final String attributes,
        @JsonProperty("available") final Boolean available,
        @JsonProperty("date_created") final String dateCreated,
        @JsonProperty("date_status_changed") final String dateStatusChanged,
        @JsonProperty("date_updated") final String dateUpdated,
        @JsonProperty("friendly_name") final String friendlyName,
        @JsonProperty("sid") final String sid,
        @JsonProperty("workspace_sid") final String workspaceSid,
        @JsonProperty("url") final URI url,
        @JsonProperty("links") final Map<String, String> links
    ) {
        this.accountSid = accountSid;
        this.activityName = activityName;
        this.activitySid = activitySid;
        this.attributes = attributes;
        this.available = available;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateStatusChanged =
            DateConverter.iso8601DateTimeFromString(dateStatusChanged);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.workspaceSid = workspaceSid;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getActivityName() {
        return this.activityName;
    }

    public final String getActivitySid() {
        return this.activitySid;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final Boolean getAvailable() {
        return this.available;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateStatusChanged() {
        return this.dateStatusChanged;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Worker other = (Worker) o;

        return (
            Objects.equals(accountSid, other.accountSid) &&
            Objects.equals(activityName, other.activityName) &&
            Objects.equals(activitySid, other.activitySid) &&
            Objects.equals(attributes, other.attributes) &&
            Objects.equals(available, other.available) &&
            Objects.equals(dateCreated, other.dateCreated) &&
            Objects.equals(dateStatusChanged, other.dateStatusChanged) &&
            Objects.equals(dateUpdated, other.dateUpdated) &&
            Objects.equals(friendlyName, other.friendlyName) &&
            Objects.equals(sid, other.sid) &&
            Objects.equals(workspaceSid, other.workspaceSid) &&
            Objects.equals(url, other.url) &&
            Objects.equals(links, other.links)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(
            accountSid,
            activityName,
            activitySid,
            attributes,
            available,
            dateCreated,
            dateStatusChanged,
            dateUpdated,
            friendlyName,
            sid,
            workspaceSid,
            url,
            links
        );
    }
}
