/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Trusthub
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.trusthub.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class ComplianceInquiries extends Resource {

    private static final long serialVersionUID = 107785038422599L;

    public static ComplianceInquiriesCreator creator(
        final String primaryProfileSid
    ) {
        return new ComplianceInquiriesCreator(primaryProfileSid);
    }

    public static ComplianceInquiriesUpdater updater(
        final String pathCustomerId,
        final String primaryProfileSid
    ) {
        return new ComplianceInquiriesUpdater(
            pathCustomerId,
            primaryProfileSid
        );
    }

    /**
     * Converts a JSON String into a ComplianceInquiries object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return ComplianceInquiries object represented by the provided JSON
     */
    public static ComplianceInquiries fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ComplianceInquiries.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a ComplianceInquiries object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return ComplianceInquiries object represented by the provided JSON
     */
    public static ComplianceInquiries fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, ComplianceInquiries.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String inquiryId;
    private final String inquirySessionToken;
    private final String customerId;
    private final URI url;

    @JsonCreator
    private ComplianceInquiries(
        @JsonProperty("inquiry_id") final String inquiryId,
        @JsonProperty("inquiry_session_token") final String inquirySessionToken,
        @JsonProperty("customer_id") final String customerId,
        @JsonProperty("url") final URI url
    ) {
        this.inquiryId = inquiryId;
        this.inquirySessionToken = inquirySessionToken;
        this.customerId = customerId;
        this.url = url;
    }

    public final String getInquiryId() {
        return this.inquiryId;
    }

    public final String getInquirySessionToken() {
        return this.inquirySessionToken;
    }

    public final String getCustomerId() {
        return this.customerId;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ComplianceInquiries other = (ComplianceInquiries) o;

        return (
            Objects.equals(inquiryId, other.inquiryId) &&
            Objects.equals(inquirySessionToken, other.inquirySessionToken) &&
            Objects.equals(customerId, other.customerId) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(inquiryId, inquirySessionToken, customerId, url);
    }
}
