/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Trusthub
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.trusthub.v1.customerprofiles;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class CustomerProfilesChannelEndpointAssignmentReader
    extends Reader<CustomerProfilesChannelEndpointAssignment> {

    private String pathCustomerProfileSid;
    private String channelEndpointSid;
    private String channelEndpointSids;
    private Integer pageSize;

    public CustomerProfilesChannelEndpointAssignmentReader(
        final String pathCustomerProfileSid
    ) {
        this.pathCustomerProfileSid = pathCustomerProfileSid;
    }

    public CustomerProfilesChannelEndpointAssignmentReader setChannelEndpointSid(
        final String channelEndpointSid
    ) {
        this.channelEndpointSid = channelEndpointSid;
        return this;
    }

    public CustomerProfilesChannelEndpointAssignmentReader setChannelEndpointSids(
        final String channelEndpointSids
    ) {
        this.channelEndpointSids = channelEndpointSids;
        return this;
    }

    public CustomerProfilesChannelEndpointAssignmentReader setPageSize(
        final Integer pageSize
    ) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<CustomerProfilesChannelEndpointAssignment> read(
        final TwilioRestClient client
    ) {
        return new ResourceSet<>(this, client, firstPage(client));
    }

    public Page<CustomerProfilesChannelEndpointAssignment> firstPage(
        final TwilioRestClient client
    ) {
        String path =
            "/v1/CustomerProfiles/{CustomerProfileSid}/ChannelEndpointAssignments";
        path =
            path.replace(
                "{" + "CustomerProfileSid" + "}",
                this.pathCustomerProfileSid.toString()
            );

        Request request = new Request(
            HttpMethod.GET,
            Domains.TRUSTHUB.toString(),
            path
        );

        addQueryParams(request);
        return pageForRequest(client, request);
    }

    private Page<CustomerProfilesChannelEndpointAssignment> pageForRequest(
        final TwilioRestClient client,
        final Request request
    ) {
        Response response = client.request(request);

        if (response == null) {
            throw new ApiConnectionException(
                "CustomerProfilesChannelEndpointAssignment read failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return Page.fromJson(
            "results",
            response.getContent(),
            CustomerProfilesChannelEndpointAssignment.class,
            client.getObjectMapper()
        );
    }

    @Override
    public Page<CustomerProfilesChannelEndpointAssignment> previousPage(
        final Page<CustomerProfilesChannelEndpointAssignment> page,
        final TwilioRestClient client
    ) {
        Request request = new Request(
            HttpMethod.GET,
            page.getPreviousPageUrl(Domains.TRUSTHUB.toString())
        );
        return pageForRequest(client, request);
    }

    @Override
    public Page<CustomerProfilesChannelEndpointAssignment> nextPage(
        final Page<CustomerProfilesChannelEndpointAssignment> page,
        final TwilioRestClient client
    ) {
        Request request = new Request(
            HttpMethod.GET,
            page.getNextPageUrl(Domains.TRUSTHUB.toString())
        );
        return pageForRequest(client, request);
    }

    @Override
    public Page<CustomerProfilesChannelEndpointAssignment> getPage(
        final String targetUrl,
        final TwilioRestClient client
    ) {
        Request request = new Request(HttpMethod.GET, targetUrl);

        return pageForRequest(client, request);
    }

    private void addQueryParams(final Request request) {
        if (channelEndpointSid != null) {
            request.addQueryParam("ChannelEndpointSid", channelEndpointSid);
        }
        if (channelEndpointSids != null) {
            request.addQueryParam("ChannelEndpointSids", channelEndpointSids);
        }
        if (pageSize != null) {
            request.addQueryParam("PageSize", pageSize.toString());
        }

        if (getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(getPageSize()));
        }
    }
}
