/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Trusthub
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.trusthub.v1.customerprofiles;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class CustomerProfilesEvaluationsCreator
    extends Creator<CustomerProfilesEvaluations> {

    private String pathCustomerProfileSid;
    private String policySid;

    public CustomerProfilesEvaluationsCreator(
        final String pathCustomerProfileSid,
        final String policySid
    ) {
        this.pathCustomerProfileSid = pathCustomerProfileSid;
        this.policySid = policySid;
    }

    public CustomerProfilesEvaluationsCreator setPolicySid(
        final String policySid
    ) {
        this.policySid = policySid;
        return this;
    }

    @Override
    public CustomerProfilesEvaluations create(final TwilioRestClient client) {
        String path = "/v1/CustomerProfiles/{CustomerProfileSid}/Evaluations";

        path =
            path.replace(
                "{" + "CustomerProfileSid" + "}",
                this.pathCustomerProfileSid.toString()
            );
        path = path.replace("{" + "PolicySid" + "}", this.policySid.toString());

        Request request = new Request(
            HttpMethod.POST,
            Domains.TRUSTHUB.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "CustomerProfilesEvaluations creation failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return CustomerProfilesEvaluations.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }

    private void addPostParams(final Request request) {
        if (policySid != null) {
            request.addPostParam("PolicySid", policySid);
        }
    }
}
