/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Trusthub
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.trusthub.v1.trustproducts;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class TrustProductsChannelEndpointAssignmentCreator
    extends Creator<TrustProductsChannelEndpointAssignment> {

    private String pathTrustProductSid;
    private String channelEndpointType;
    private String channelEndpointSid;

    public TrustProductsChannelEndpointAssignmentCreator(
        final String pathTrustProductSid,
        final String channelEndpointType,
        final String channelEndpointSid
    ) {
        this.pathTrustProductSid = pathTrustProductSid;
        this.channelEndpointType = channelEndpointType;
        this.channelEndpointSid = channelEndpointSid;
    }

    public TrustProductsChannelEndpointAssignmentCreator setChannelEndpointType(
        final String channelEndpointType
    ) {
        this.channelEndpointType = channelEndpointType;
        return this;
    }

    public TrustProductsChannelEndpointAssignmentCreator setChannelEndpointSid(
        final String channelEndpointSid
    ) {
        this.channelEndpointSid = channelEndpointSid;
        return this;
    }

    @Override
    public TrustProductsChannelEndpointAssignment create(
        final TwilioRestClient client
    ) {
        String path =
            "/v1/TrustProducts/{TrustProductSid}/ChannelEndpointAssignments";

        path =
            path.replace(
                "{" + "TrustProductSid" + "}",
                this.pathTrustProductSid.toString()
            );
        path =
            path.replace(
                "{" + "ChannelEndpointType" + "}",
                this.channelEndpointType.toString()
            );
        path =
            path.replace(
                "{" + "ChannelEndpointSid" + "}",
                this.channelEndpointSid.toString()
            );

        Request request = new Request(
            HttpMethod.POST,
            Domains.TRUSTHUB.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "TrustProductsChannelEndpointAssignment creation failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return TrustProductsChannelEndpointAssignment.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }

    private void addPostParams(final Request request) {
        if (channelEndpointType != null) {
            request.addPostParam("ChannelEndpointType", channelEndpointType);
        }
        if (channelEndpointSid != null) {
            request.addPostParam("ChannelEndpointSid", channelEndpointSid);
        }
    }
}
