/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.verify.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Map;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Form extends Resource {

    private static final long serialVersionUID = 202517967097226L;

    public static FormFetcher fetcher(final Form.FormTypes formType) {
        return new FormFetcher(formType);
    }

    /**
     * Converts a JSON String into a Form object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Form object represented by the provided JSON
     */
    public static Form fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Form.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Form object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Form object represented by the provided JSON
     */
    public static Form fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Form.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public enum FormTypes {
        FORM_PUSH("form-push");

        private final String value;

        private FormTypes(final String value) {
            this.value = value;
        }

        public String toString() {
            return value;
        }

        @JsonCreator
        public static FormTypes forValue(final String value) {
            return Promoter.enumFromString(value, FormTypes.values());
        }
    }

    private final Form.FormTypes formType;
    private final Map<String, Object> forms;
    private final Map<String, Object> formMeta;
    private final URI url;

    @JsonCreator
    private Form(
        @JsonProperty("form_type") final Form.FormTypes formType,
        @JsonProperty("forms") final Map<String, Object> forms,
        @JsonProperty("form_meta") final Map<String, Object> formMeta,
        @JsonProperty("url") final URI url
    ) {
        this.formType = formType;
        this.forms = forms;
        this.formMeta = formMeta;
        this.url = url;
    }

    public final Form.FormTypes getFormType() {
        return this.formType;
    }

    public final Map<String, Object> getForms() {
        return this.forms;
    }

    public final Map<String, Object> getFormMeta() {
        return this.formMeta;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Form other = (Form) o;

        return (
            Objects.equals(formType, other.formType) &&
            Objects.equals(forms, other.forms) &&
            Objects.equals(formMeta, other.formMeta) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(formType, forms, formMeta, url);
    }
}
