/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.verify.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import lombok.ToString;
import lombok.ToString;

@JsonIgnoreProperties(ignoreUnknown = true)
@ToString
public class Safelist extends Resource {

    private static final long serialVersionUID = 83566412587236L;

    public static SafelistCreator creator(final String phoneNumber) {
        return new SafelistCreator(phoneNumber);
    }

    public static SafelistDeleter deleter(final String pathPhoneNumber) {
        return new SafelistDeleter(pathPhoneNumber);
    }

    public static SafelistFetcher fetcher(final String pathPhoneNumber) {
        return new SafelistFetcher(pathPhoneNumber);
    }

    /**
     * Converts a JSON String into a Safelist object using the provided ObjectMapper.
     *
     * @param json Raw JSON String
     * @param objectMapper Jackson ObjectMapper
     * @return Safelist object represented by the provided JSON
     */
    public static Safelist fromJson(
        final String json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Safelist.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    /**
     * Converts a JSON InputStream into a Safelist object using the provided
     * ObjectMapper.
     *
     * @param json Raw JSON InputStream
     * @param objectMapper Jackson ObjectMapper
     * @return Safelist object represented by the provided JSON
     */
    public static Safelist fromJson(
        final InputStream json,
        final ObjectMapper objectMapper
    ) {
        // Convert all checked exceptions to Runtime
        try {
            return objectMapper.readValue(json, Safelist.class);
        } catch (final JsonMappingException | JsonParseException e) {
            throw new ApiException(e.getMessage(), e);
        } catch (final IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    private final String sid;
    private final String phoneNumber;
    private final URI url;

    @JsonCreator
    private Safelist(
        @JsonProperty("sid") final String sid,
        @JsonProperty("phone_number") final String phoneNumber,
        @JsonProperty("url") final URI url
    ) {
        this.sid = sid;
        this.phoneNumber = phoneNumber;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getPhoneNumber() {
        return this.phoneNumber;
    }

    public final URI getUrl() {
        return this.url;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Safelist other = (Safelist) o;

        return (
            Objects.equals(sid, other.sid) &&
            Objects.equals(phoneNumber, other.phoneNumber) &&
            Objects.equals(url, other.url)
        );
    }

    @Override
    public int hashCode() {
        return Objects.hash(sid, phoneNumber, url);
    }
}
