/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;

public class VerificationCheckCreator extends Creator<VerificationCheck> {

    private String pathServiceSid;
    private String code;
    private String to;
    private String verificationSid;
    private String amount;
    private String payee;

    public VerificationCheckCreator(final String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public VerificationCheckCreator setCode(final String code) {
        this.code = code;
        return this;
    }

    public VerificationCheckCreator setTo(final String to) {
        this.to = to;
        return this;
    }

    public VerificationCheckCreator setVerificationSid(
        final String verificationSid
    ) {
        this.verificationSid = verificationSid;
        return this;
    }

    public VerificationCheckCreator setAmount(final String amount) {
        this.amount = amount;
        return this;
    }

    public VerificationCheckCreator setPayee(final String payee) {
        this.payee = payee;
        return this;
    }

    @Override
    public VerificationCheck create(final TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/VerificationCheck";

        path =
            path.replace(
                "{" + "ServiceSid" + "}",
                this.pathServiceSid.toString()
            );

        Request request = new Request(
            HttpMethod.POST,
            Domains.VERIFY.toString(),
            path
        );
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException(
                "VerificationCheck creation failed: Unable to connect to server"
            );
        } else if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(
                response.getStream(),
                client.getObjectMapper()
            );
            if (restException == null) {
                throw new ApiException(
                    "Server Error, no content",
                    response.getStatusCode()
                );
            }
            throw new ApiException(restException);
        }

        return VerificationCheck.fromJson(
            response.getStream(),
            client.getObjectMapper()
        );
    }

    private void addPostParams(final Request request) {
        if (code != null) {
            request.addPostParam("Code", code);
        }
        if (to != null) {
            request.addPostParam("To", to);
        }
        if (verificationSid != null) {
            request.addPostParam("VerificationSid", verificationSid);
        }
        if (amount != null) {
            request.addPostParam("Amount", amount);
        }
        if (payee != null) {
            request.addPostParam("Payee", payee);
        }
    }
}
